/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.clouddirectory.model.TypedLinkAttributeRange;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class TypedLinkAttributeRangeMarshaller {
    private static final MarshallingInfo<String> ATTRIBUTENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AttributeName").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> RANGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Range").isBinary(false).build();
    private static final TypedLinkAttributeRangeMarshaller INSTANCE = new TypedLinkAttributeRangeMarshaller();

    private TypedLinkAttributeRangeMarshaller() {
    }

    public static TypedLinkAttributeRangeMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(TypedLinkAttributeRange typedLinkAttributeRange, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)typedLinkAttributeRange, (String)"typedLinkAttributeRange");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)typedLinkAttributeRange.attributeName(), ATTRIBUTENAME_BINDING);
            protocolMarshaller.marshall((Object)typedLinkAttributeRange.range(), RANGE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

