/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.clouddirectory.model.BatchReadRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class BatchReadRequestModelMarshaller {
    private static final MarshallingInfo<String> DIRECTORYARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.HEADER).marshallLocationName("x-amz-data-partition").isBinary(false).build();
    private static final MarshallingInfo<List> OPERATIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Operations").isBinary(false).build();
    private static final MarshallingInfo<String> CONSISTENCYLEVEL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.HEADER).marshallLocationName("x-amz-consistency-level").isBinary(false).build();
    private static final BatchReadRequestModelMarshaller INSTANCE = new BatchReadRequestModelMarshaller();

    private BatchReadRequestModelMarshaller() {
    }

    public static BatchReadRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(BatchReadRequest batchReadRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)batchReadRequest), (String)"batchReadRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)batchReadRequest.directoryArn(), DIRECTORYARN_BINDING);
            protocolMarshaller.marshall(batchReadRequest.operations(), OPERATIONS_BINDING);
            protocolMarshaller.marshall((Object)batchReadRequest.consistencyLevelAsString(), CONSISTENCYLEVEL_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

