/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.clouddirectory.model.BatchAttachTypedLink;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class BatchAttachTypedLinkMarshaller {
    private static final MarshallingInfo<StructuredPojo> SOURCEOBJECTREFERENCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SourceObjectReference").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> TARGETOBJECTREFERENCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TargetObjectReference").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> TYPEDLINKFACET_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TypedLinkFacet").isBinary(false).build();
    private static final MarshallingInfo<List> ATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Attributes").isBinary(false).build();
    private static final BatchAttachTypedLinkMarshaller INSTANCE = new BatchAttachTypedLinkMarshaller();

    private BatchAttachTypedLinkMarshaller() {
    }

    public static BatchAttachTypedLinkMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(BatchAttachTypedLink batchAttachTypedLink, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)batchAttachTypedLink, (String)"batchAttachTypedLink");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)batchAttachTypedLink.sourceObjectReference(), SOURCEOBJECTREFERENCE_BINDING);
            protocolMarshaller.marshall((Object)batchAttachTypedLink.targetObjectReference(), TARGETOBJECTREFERENCE_BINDING);
            protocolMarshaller.marshall((Object)batchAttachTypedLink.typedLinkFacet(), TYPEDLINKFACET_BINDING);
            protocolMarshaller.marshall(batchAttachTypedLink.attributes(), ATTRIBUTES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

