/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.clouddirectory.model.ApplySchemaRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ApplySchemaRequestModelMarshaller {
    private static final MarshallingInfo<String> PUBLISHEDSCHEMAARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PublishedSchemaArn").isBinary(false).build();
    private static final MarshallingInfo<String> DIRECTORYARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.HEADER).marshallLocationName("x-amz-data-partition").isBinary(false).build();
    private static final ApplySchemaRequestModelMarshaller INSTANCE = new ApplySchemaRequestModelMarshaller();

    private ApplySchemaRequestModelMarshaller() {
    }

    public static ApplySchemaRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ApplySchemaRequest applySchemaRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)applySchemaRequest), (String)"applySchemaRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)applySchemaRequest.publishedSchemaArn(), PUBLISHEDSCHEMAARN_BINDING);
            protocolMarshaller.marshall((Object)applySchemaRequest.directoryArn(), DIRECTORYARN_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

