/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.clouddirectory.CloudDirectoryAsyncClient;
import software.amazon.awssdk.services.clouddirectory.model.ListTypedLinkFacetNamesRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListTypedLinkFacetNamesResponse;

public class ListTypedLinkFacetNamesPublisher
implements SdkPublisher<ListTypedLinkFacetNamesResponse> {
    private final CloudDirectoryAsyncClient client;
    private final ListTypedLinkFacetNamesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListTypedLinkFacetNamesPublisher(CloudDirectoryAsyncClient client, ListTypedLinkFacetNamesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListTypedLinkFacetNamesPublisher(CloudDirectoryAsyncClient client, ListTypedLinkFacetNamesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListTypedLinkFacetNamesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListTypedLinkFacetNamesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final ListTypedLinkFacetNamesPublisher resume(ListTypedLinkFacetNamesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListTypedLinkFacetNamesPublisher(this.client, (ListTypedLinkFacetNamesRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListTypedLinkFacetNamesPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListTypedLinkFacetNamesResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListTypedLinkFacetNamesResponseFetcher
    implements AsyncPageFetcher<ListTypedLinkFacetNamesResponse> {
        private ListTypedLinkFacetNamesResponseFetcher() {
        }

        public boolean hasNextPage(ListTypedLinkFacetNamesResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public CompletableFuture<ListTypedLinkFacetNamesResponse> nextPage(ListTypedLinkFacetNamesResponse previousPage) {
            if (previousPage == null) {
                return ListTypedLinkFacetNamesPublisher.this.client.listTypedLinkFacetNames(ListTypedLinkFacetNamesPublisher.this.firstRequest);
            }
            return ListTypedLinkFacetNamesPublisher.this.client.listTypedLinkFacetNames((ListTypedLinkFacetNamesRequest)((Object)ListTypedLinkFacetNamesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

