/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.clouddirectory.CloudDirectoryAsyncClient;
import software.amazon.awssdk.services.clouddirectory.model.ListPublishedSchemaArnsRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListPublishedSchemaArnsResponse;

public class ListPublishedSchemaArnsPublisher
implements SdkPublisher<ListPublishedSchemaArnsResponse> {
    private final CloudDirectoryAsyncClient client;
    private final ListPublishedSchemaArnsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListPublishedSchemaArnsPublisher(CloudDirectoryAsyncClient client, ListPublishedSchemaArnsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListPublishedSchemaArnsPublisher(CloudDirectoryAsyncClient client, ListPublishedSchemaArnsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListPublishedSchemaArnsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListPublishedSchemaArnsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final ListPublishedSchemaArnsPublisher resume(ListPublishedSchemaArnsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListPublishedSchemaArnsPublisher(this.client, (ListPublishedSchemaArnsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListPublishedSchemaArnsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListPublishedSchemaArnsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListPublishedSchemaArnsResponseFetcher
    implements AsyncPageFetcher<ListPublishedSchemaArnsResponse> {
        private ListPublishedSchemaArnsResponseFetcher() {
        }

        public boolean hasNextPage(ListPublishedSchemaArnsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public CompletableFuture<ListPublishedSchemaArnsResponse> nextPage(ListPublishedSchemaArnsResponse previousPage) {
            if (previousPage == null) {
                return ListPublishedSchemaArnsPublisher.this.client.listPublishedSchemaArns(ListPublishedSchemaArnsPublisher.this.firstRequest);
            }
            return ListPublishedSchemaArnsPublisher.this.client.listPublishedSchemaArns((ListPublishedSchemaArnsRequest)((Object)ListPublishedSchemaArnsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

