/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.clouddirectory.model.FacetAttributeType;
import software.amazon.awssdk.services.clouddirectory.model.RequiredAttributeBehavior;
import software.amazon.awssdk.services.clouddirectory.model.Rule;
import software.amazon.awssdk.services.clouddirectory.model.RuleMapCopier;
import software.amazon.awssdk.services.clouddirectory.model.TypedAttributeValue;
import software.amazon.awssdk.services.clouddirectory.transform.TypedLinkAttributeDefinitionMarshaller;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class TypedLinkAttributeDefinition
implements StructuredPojo,
ToCopyableBuilder<Builder, TypedLinkAttributeDefinition> {
    private final String name;
    private final String type;
    private final TypedAttributeValue defaultValue;
    private final Boolean isImmutable;
    private final Map<String, Rule> rules;
    private final String requiredBehavior;

    private TypedLinkAttributeDefinition(BuilderImpl builder) {
        this.name = builder.name;
        this.type = builder.type;
        this.defaultValue = builder.defaultValue;
        this.isImmutable = builder.isImmutable;
        this.rules = builder.rules;
        this.requiredBehavior = builder.requiredBehavior;
    }

    public String name() {
        return this.name;
    }

    public FacetAttributeType type() {
        return FacetAttributeType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public TypedAttributeValue defaultValue() {
        return this.defaultValue;
    }

    public Boolean isImmutable() {
        return this.isImmutable;
    }

    public Map<String, Rule> rules() {
        return this.rules;
    }

    public RequiredAttributeBehavior requiredBehavior() {
        return RequiredAttributeBehavior.fromValue(this.requiredBehavior);
    }

    public String requiredBehaviorAsString() {
        return this.requiredBehavior;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.isImmutable());
        hashCode = 31 * hashCode + Objects.hashCode(this.rules());
        hashCode = 31 * hashCode + Objects.hashCode(this.requiredBehaviorAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TypedLinkAttributeDefinition)) {
            return false;
        }
        TypedLinkAttributeDefinition other = (TypedLinkAttributeDefinition)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.defaultValue(), other.defaultValue()) && Objects.equals(this.isImmutable(), other.isImmutable()) && Objects.equals(this.rules(), other.rules()) && Objects.equals(this.requiredBehaviorAsString(), other.requiredBehaviorAsString());
    }

    public String toString() {
        return ToString.builder((String)"TypedLinkAttributeDefinition").add("Name", (Object)this.name()).add("Type", (Object)this.typeAsString()).add("DefaultValue", (Object)this.defaultValue()).add("IsImmutable", (Object)this.isImmutable()).add("Rules", this.rules()).add("RequiredBehavior", (Object)this.requiredBehaviorAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "Type": {
                return Optional.of(clazz.cast(this.typeAsString()));
            }
            case "DefaultValue": {
                return Optional.of(clazz.cast(this.defaultValue()));
            }
            case "IsImmutable": {
                return Optional.of(clazz.cast(this.isImmutable()));
            }
            case "Rules": {
                return Optional.of(clazz.cast(this.rules()));
            }
            case "RequiredBehavior": {
                return Optional.of(clazz.cast(this.requiredBehaviorAsString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TypedLinkAttributeDefinitionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String type;
        private TypedAttributeValue defaultValue;
        private Boolean isImmutable;
        private Map<String, Rule> rules;
        private String requiredBehavior;

        private BuilderImpl() {
        }

        private BuilderImpl(TypedLinkAttributeDefinition model) {
            this.name(model.name);
            this.type(model.type);
            this.defaultValue(model.defaultValue);
            this.isImmutable(model.isImmutable);
            this.rules(model.rules);
            this.requiredBehavior(model.requiredBehavior);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(FacetAttributeType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final TypedAttributeValue.Builder getDefaultValue() {
            return this.defaultValue != null ? this.defaultValue.toBuilder() : null;
        }

        @Override
        public final Builder defaultValue(TypedAttributeValue defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public final void setDefaultValue(TypedAttributeValue.BuilderImpl defaultValue) {
            this.defaultValue = defaultValue != null ? defaultValue.build() : null;
        }

        public final Boolean getIsImmutable() {
            return this.isImmutable;
        }

        @Override
        public final Builder isImmutable(Boolean isImmutable) {
            this.isImmutable = isImmutable;
            return this;
        }

        public final void setIsImmutable(Boolean isImmutable) {
            this.isImmutable = isImmutable;
        }

        public final Map<String, Rule.Builder> getRules() {
            return this.rules != null ? CollectionUtils.mapValues(this.rules, Rule::toBuilder) : null;
        }

        @Override
        public final Builder rules(Map<String, Rule> rules) {
            this.rules = RuleMapCopier.copy(rules);
            return this;
        }

        public final void setRules(Map<String, Rule.BuilderImpl> rules) {
            this.rules = RuleMapCopier.copyFromBuilder(rules);
        }

        public final String getRequiredBehavior() {
            return this.requiredBehavior;
        }

        @Override
        public final Builder requiredBehavior(String requiredBehavior) {
            this.requiredBehavior = requiredBehavior;
            return this;
        }

        @Override
        public final Builder requiredBehavior(RequiredAttributeBehavior requiredBehavior) {
            this.requiredBehavior(requiredBehavior.toString());
            return this;
        }

        public final void setRequiredBehavior(String requiredBehavior) {
            this.requiredBehavior = requiredBehavior;
        }

        public TypedLinkAttributeDefinition build() {
            return new TypedLinkAttributeDefinition(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, TypedLinkAttributeDefinition> {
        public Builder name(String var1);

        public Builder type(String var1);

        public Builder type(FacetAttributeType var1);

        public Builder defaultValue(TypedAttributeValue var1);

        default public Builder defaultValue(Consumer<TypedAttributeValue.Builder> defaultValue) {
            return this.defaultValue((TypedAttributeValue)((TypedAttributeValue.Builder)TypedAttributeValue.builder().apply(defaultValue)).build());
        }

        public Builder isImmutable(Boolean var1);

        public Builder rules(Map<String, Rule> var1);

        public Builder requiredBehavior(String var1);

        public Builder requiredBehavior(RequiredAttributeBehavior var1);
    }
}

