/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.clouddirectory.model.RangeMode;
import software.amazon.awssdk.services.clouddirectory.model.TypedAttributeValue;
import software.amazon.awssdk.services.clouddirectory.transform.TypedAttributeValueRangeMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class TypedAttributeValueRange
implements StructuredPojo,
ToCopyableBuilder<Builder, TypedAttributeValueRange> {
    private final String startMode;
    private final TypedAttributeValue startValue;
    private final String endMode;
    private final TypedAttributeValue endValue;

    private TypedAttributeValueRange(BuilderImpl builder) {
        this.startMode = builder.startMode;
        this.startValue = builder.startValue;
        this.endMode = builder.endMode;
        this.endValue = builder.endValue;
    }

    public RangeMode startMode() {
        return RangeMode.fromValue(this.startMode);
    }

    public String startModeAsString() {
        return this.startMode;
    }

    public TypedAttributeValue startValue() {
        return this.startValue;
    }

    public RangeMode endMode() {
        return RangeMode.fromValue(this.endMode);
    }

    public String endModeAsString() {
        return this.endMode;
    }

    public TypedAttributeValue endValue() {
        return this.endValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.startModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.startValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.endModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.endValue());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TypedAttributeValueRange)) {
            return false;
        }
        TypedAttributeValueRange other = (TypedAttributeValueRange)obj;
        return Objects.equals(this.startModeAsString(), other.startModeAsString()) && Objects.equals(this.startValue(), other.startValue()) && Objects.equals(this.endModeAsString(), other.endModeAsString()) && Objects.equals(this.endValue(), other.endValue());
    }

    public String toString() {
        return ToString.builder((String)"TypedAttributeValueRange").add("StartMode", (Object)this.startModeAsString()).add("StartValue", (Object)this.startValue()).add("EndMode", (Object)this.endModeAsString()).add("EndValue", (Object)this.endValue()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StartMode": {
                return Optional.of(clazz.cast(this.startModeAsString()));
            }
            case "StartValue": {
                return Optional.of(clazz.cast(this.startValue()));
            }
            case "EndMode": {
                return Optional.of(clazz.cast(this.endModeAsString()));
            }
            case "EndValue": {
                return Optional.of(clazz.cast(this.endValue()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TypedAttributeValueRangeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String startMode;
        private TypedAttributeValue startValue;
        private String endMode;
        private TypedAttributeValue endValue;

        private BuilderImpl() {
        }

        private BuilderImpl(TypedAttributeValueRange model) {
            this.startMode(model.startMode);
            this.startValue(model.startValue);
            this.endMode(model.endMode);
            this.endValue(model.endValue);
        }

        public final String getStartMode() {
            return this.startMode;
        }

        @Override
        public final Builder startMode(String startMode) {
            this.startMode = startMode;
            return this;
        }

        @Override
        public final Builder startMode(RangeMode startMode) {
            this.startMode(startMode.toString());
            return this;
        }

        public final void setStartMode(String startMode) {
            this.startMode = startMode;
        }

        public final TypedAttributeValue.Builder getStartValue() {
            return this.startValue != null ? this.startValue.toBuilder() : null;
        }

        @Override
        public final Builder startValue(TypedAttributeValue startValue) {
            this.startValue = startValue;
            return this;
        }

        public final void setStartValue(TypedAttributeValue.BuilderImpl startValue) {
            this.startValue = startValue != null ? startValue.build() : null;
        }

        public final String getEndMode() {
            return this.endMode;
        }

        @Override
        public final Builder endMode(String endMode) {
            this.endMode = endMode;
            return this;
        }

        @Override
        public final Builder endMode(RangeMode endMode) {
            this.endMode(endMode.toString());
            return this;
        }

        public final void setEndMode(String endMode) {
            this.endMode = endMode;
        }

        public final TypedAttributeValue.Builder getEndValue() {
            return this.endValue != null ? this.endValue.toBuilder() : null;
        }

        @Override
        public final Builder endValue(TypedAttributeValue endValue) {
            this.endValue = endValue;
            return this;
        }

        public final void setEndValue(TypedAttributeValue.BuilderImpl endValue) {
            this.endValue = endValue != null ? endValue.build() : null;
        }

        public TypedAttributeValueRange build() {
            return new TypedAttributeValueRange(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, TypedAttributeValueRange> {
        public Builder startMode(String var1);

        public Builder startMode(RangeMode var1);

        public Builder startValue(TypedAttributeValue var1);

        default public Builder startValue(Consumer<TypedAttributeValue.Builder> startValue) {
            return this.startValue((TypedAttributeValue)((TypedAttributeValue.Builder)TypedAttributeValue.builder().apply(startValue)).build());
        }

        public Builder endMode(String var1);

        public Builder endMode(RangeMode var1);

        public Builder endValue(TypedAttributeValue var1);

        default public Builder endValue(Consumer<TypedAttributeValue.Builder> endValue) {
            return this.endValue((TypedAttributeValue)((TypedAttributeValue.Builder)TypedAttributeValue.builder().apply(endValue)).build());
        }
    }
}

