/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.clouddirectory.model.CloudDirectoryRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateDirectoryRequest
extends CloudDirectoryRequest
implements ToCopyableBuilder<Builder, CreateDirectoryRequest> {
    private final String name;
    private final String schemaArn;

    private CreateDirectoryRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.schemaArn = builder.schemaArn;
    }

    public String name() {
        return this.name;
    }

    public String schemaArn() {
        return this.schemaArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDirectoryRequest)) {
            return false;
        }
        CreateDirectoryRequest other = (CreateDirectoryRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.schemaArn(), other.schemaArn());
    }

    public String toString() {
        return ToString.builder((String)"CreateDirectoryRequest").add("Name", (Object)this.name()).add("SchemaArn", (Object)this.schemaArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "SchemaArn": {
                return Optional.of(clazz.cast(this.schemaArn()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CloudDirectoryRequest.BuilderImpl
    implements Builder {
        private String name;
        private String schemaArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDirectoryRequest model) {
            super(model);
            this.name(model.name);
            this.schemaArn(model.schemaArn);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getSchemaArn() {
            return this.schemaArn;
        }

        @Override
        public final Builder schemaArn(String schemaArn) {
            this.schemaArn = schemaArn;
            return this;
        }

        public final void setSchemaArn(String schemaArn) {
            this.schemaArn = schemaArn;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateDirectoryRequest build() {
            return new CreateDirectoryRequest(this);
        }
    }

    public static interface Builder
    extends CloudDirectoryRequest.Builder,
    CopyableBuilder<Builder, CreateDirectoryRequest> {
        public Builder name(String var1);

        public Builder schemaArn(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

