/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.clouddirectory.model.BatchWriteOperationResponse;
import software.amazon.awssdk.services.clouddirectory.model.BatchWriteOperationResponseListCopier;
import software.amazon.awssdk.services.clouddirectory.model.CloudDirectoryResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class BatchWriteResponse
extends CloudDirectoryResponse
implements ToCopyableBuilder<Builder, BatchWriteResponse> {
    private final List<BatchWriteOperationResponse> responses;

    private BatchWriteResponse(BuilderImpl builder) {
        super(builder);
        this.responses = builder.responses;
    }

    public List<BatchWriteOperationResponse> responses() {
        return this.responses;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.responses());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchWriteResponse)) {
            return false;
        }
        BatchWriteResponse other = (BatchWriteResponse)((Object)obj);
        return Objects.equals(this.responses(), other.responses());
    }

    public String toString() {
        return ToString.builder((String)"BatchWriteResponse").add("Responses", this.responses()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Responses": {
                return Optional.of(clazz.cast(this.responses()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CloudDirectoryResponse.BuilderImpl
    implements Builder {
        private List<BatchWriteOperationResponse> responses;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchWriteResponse model) {
            super(model);
            this.responses(model.responses);
        }

        public final Collection<BatchWriteOperationResponse.Builder> getResponses() {
            return this.responses != null ? (Collection)this.responses.stream().map(BatchWriteOperationResponse::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder responses(Collection<BatchWriteOperationResponse> responses) {
            this.responses = BatchWriteOperationResponseListCopier.copy(responses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder responses(BatchWriteOperationResponse ... responses) {
            this.responses(Arrays.asList(responses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder responses(Consumer<BatchWriteOperationResponse.Builder> ... responses) {
            this.responses(Stream.of(responses).map(c -> (BatchWriteOperationResponse)((BatchWriteOperationResponse.Builder)BatchWriteOperationResponse.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setResponses(Collection<BatchWriteOperationResponse.BuilderImpl> responses) {
            this.responses = BatchWriteOperationResponseListCopier.copyFromBuilder(responses);
        }

        @Override
        public BatchWriteResponse build() {
            return new BatchWriteResponse(this);
        }
    }

    public static interface Builder
    extends CloudDirectoryResponse.Builder,
    CopyableBuilder<Builder, BatchWriteResponse> {
        public Builder responses(Collection<BatchWriteOperationResponse> var1);

        public Builder responses(BatchWriteOperationResponse ... var1);

        public Builder responses(Consumer<BatchWriteOperationResponse.Builder> ... var1);
    }
}

