/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.clouddirectory.model.ObjectIdentifierListCopier;
import software.amazon.awssdk.services.clouddirectory.transform.BatchListObjectPoliciesResponseMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class BatchListObjectPoliciesResponse
implements StructuredPojo,
ToCopyableBuilder<Builder, BatchListObjectPoliciesResponse> {
    private final List<String> attachedPolicyIds;
    private final String nextToken;

    private BatchListObjectPoliciesResponse(BuilderImpl builder) {
        this.attachedPolicyIds = builder.attachedPolicyIds;
        this.nextToken = builder.nextToken;
    }

    public List<String> attachedPolicyIds() {
        return this.attachedPolicyIds;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.attachedPolicyIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchListObjectPoliciesResponse)) {
            return false;
        }
        BatchListObjectPoliciesResponse other = (BatchListObjectPoliciesResponse)obj;
        return Objects.equals(this.attachedPolicyIds(), other.attachedPolicyIds()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"BatchListObjectPoliciesResponse").add("AttachedPolicyIds", this.attachedPolicyIds()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AttachedPolicyIds": {
                return Optional.of(clazz.cast(this.attachedPolicyIds()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BatchListObjectPoliciesResponseMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> attachedPolicyIds;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchListObjectPoliciesResponse model) {
            this.attachedPolicyIds(model.attachedPolicyIds);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getAttachedPolicyIds() {
            return this.attachedPolicyIds;
        }

        @Override
        public final Builder attachedPolicyIds(Collection<String> attachedPolicyIds) {
            this.attachedPolicyIds = ObjectIdentifierListCopier.copy(attachedPolicyIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachedPolicyIds(String ... attachedPolicyIds) {
            this.attachedPolicyIds(Arrays.asList(attachedPolicyIds));
            return this;
        }

        public final void setAttachedPolicyIds(Collection<String> attachedPolicyIds) {
            this.attachedPolicyIds = ObjectIdentifierListCopier.copy(attachedPolicyIds);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public BatchListObjectPoliciesResponse build() {
            return new BatchListObjectPoliciesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, BatchListObjectPoliciesResponse> {
        public Builder attachedPolicyIds(Collection<String> var1);

        public Builder attachedPolicyIds(String ... var1);

        public Builder nextToken(String var1);
    }
}

