/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.clouddirectory.model.ObjectAttributeRange;
import software.amazon.awssdk.services.clouddirectory.model.ObjectAttributeRangeListCopier;
import software.amazon.awssdk.services.clouddirectory.model.ObjectReference;
import software.amazon.awssdk.services.clouddirectory.transform.BatchListIndexMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class BatchListIndex
implements StructuredPojo,
ToCopyableBuilder<Builder, BatchListIndex> {
    private final List<ObjectAttributeRange> rangesOnIndexedValues;
    private final ObjectReference indexReference;
    private final Integer maxResults;
    private final String nextToken;

    private BatchListIndex(BuilderImpl builder) {
        this.rangesOnIndexedValues = builder.rangesOnIndexedValues;
        this.indexReference = builder.indexReference;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public List<ObjectAttributeRange> rangesOnIndexedValues() {
        return this.rangesOnIndexedValues;
    }

    public ObjectReference indexReference() {
        return this.indexReference;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.rangesOnIndexedValues());
        hashCode = 31 * hashCode + Objects.hashCode(this.indexReference());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchListIndex)) {
            return false;
        }
        BatchListIndex other = (BatchListIndex)obj;
        return Objects.equals(this.rangesOnIndexedValues(), other.rangesOnIndexedValues()) && Objects.equals(this.indexReference(), other.indexReference()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"BatchListIndex").add("RangesOnIndexedValues", this.rangesOnIndexedValues()).add("IndexReference", (Object)this.indexReference()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RangesOnIndexedValues": {
                return Optional.of(clazz.cast(this.rangesOnIndexedValues()));
            }
            case "IndexReference": {
                return Optional.of(clazz.cast(this.indexReference()));
            }
            case "MaxResults": {
                return Optional.of(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BatchListIndexMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private List<ObjectAttributeRange> rangesOnIndexedValues;
        private ObjectReference indexReference;
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchListIndex model) {
            this.rangesOnIndexedValues(model.rangesOnIndexedValues);
            this.indexReference(model.indexReference);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final Collection<ObjectAttributeRange.Builder> getRangesOnIndexedValues() {
            return this.rangesOnIndexedValues != null ? (Collection)this.rangesOnIndexedValues.stream().map(ObjectAttributeRange::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder rangesOnIndexedValues(Collection<ObjectAttributeRange> rangesOnIndexedValues) {
            this.rangesOnIndexedValues = ObjectAttributeRangeListCopier.copy(rangesOnIndexedValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rangesOnIndexedValues(ObjectAttributeRange ... rangesOnIndexedValues) {
            this.rangesOnIndexedValues(Arrays.asList(rangesOnIndexedValues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rangesOnIndexedValues(Consumer<ObjectAttributeRange.Builder> ... rangesOnIndexedValues) {
            this.rangesOnIndexedValues(Stream.of(rangesOnIndexedValues).map(c -> (ObjectAttributeRange)((ObjectAttributeRange.Builder)ObjectAttributeRange.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRangesOnIndexedValues(Collection<ObjectAttributeRange.BuilderImpl> rangesOnIndexedValues) {
            this.rangesOnIndexedValues = ObjectAttributeRangeListCopier.copyFromBuilder(rangesOnIndexedValues);
        }

        public final ObjectReference.Builder getIndexReference() {
            return this.indexReference != null ? this.indexReference.toBuilder() : null;
        }

        @Override
        public final Builder indexReference(ObjectReference indexReference) {
            this.indexReference = indexReference;
            return this;
        }

        public final void setIndexReference(ObjectReference.BuilderImpl indexReference) {
            this.indexReference = indexReference != null ? indexReference.build() : null;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public BatchListIndex build() {
            return new BatchListIndex(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, BatchListIndex> {
        public Builder rangesOnIndexedValues(Collection<ObjectAttributeRange> var1);

        public Builder rangesOnIndexedValues(ObjectAttributeRange ... var1);

        public Builder rangesOnIndexedValues(Consumer<ObjectAttributeRange.Builder> ... var1);

        public Builder indexReference(ObjectReference var1);

        default public Builder indexReference(Consumer<ObjectReference.Builder> indexReference) {
            return this.indexReference((ObjectReference)((ObjectReference.Builder)ObjectReference.builder().apply(indexReference)).build());
        }

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);
    }
}

