/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.nio.ByteBuffer;
import java.util.Date;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.clouddirectory.transform.TypedAttributeValueMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class TypedAttributeValue
implements StructuredPojo,
ToCopyableBuilder<Builder, TypedAttributeValue> {
    private final String stringValue;
    private final ByteBuffer binaryValue;
    private final Boolean booleanValue;
    private final String numberValue;
    private final Date datetimeValue;

    private TypedAttributeValue(BuilderImpl builder) {
        this.stringValue = builder.stringValue;
        this.binaryValue = builder.binaryValue;
        this.booleanValue = builder.booleanValue;
        this.numberValue = builder.numberValue;
        this.datetimeValue = builder.datetimeValue;
    }

    public String stringValue() {
        return this.stringValue;
    }

    public ByteBuffer binaryValue() {
        return this.binaryValue;
    }

    public Boolean booleanValue() {
        return this.booleanValue;
    }

    public String numberValue() {
        return this.numberValue;
    }

    public Date datetimeValue() {
        return this.datetimeValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.stringValue() == null ? 0 : this.stringValue().hashCode());
        hashCode = 31 * hashCode + (this.binaryValue() == null ? 0 : this.binaryValue().hashCode());
        hashCode = 31 * hashCode + (this.booleanValue() == null ? 0 : this.booleanValue().hashCode());
        hashCode = 31 * hashCode + (this.numberValue() == null ? 0 : this.numberValue().hashCode());
        hashCode = 31 * hashCode + (this.datetimeValue() == null ? 0 : this.datetimeValue().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TypedAttributeValue)) {
            return false;
        }
        TypedAttributeValue other = (TypedAttributeValue)obj;
        if (other.stringValue() == null ^ this.stringValue() == null) {
            return false;
        }
        if (other.stringValue() != null && !other.stringValue().equals(this.stringValue())) {
            return false;
        }
        if (other.binaryValue() == null ^ this.binaryValue() == null) {
            return false;
        }
        if (other.binaryValue() != null && !other.binaryValue().equals(this.binaryValue())) {
            return false;
        }
        if (other.booleanValue() == null ^ this.booleanValue() == null) {
            return false;
        }
        if (other.booleanValue() != null && !other.booleanValue().equals(this.booleanValue())) {
            return false;
        }
        if (other.numberValue() == null ^ this.numberValue() == null) {
            return false;
        }
        if (other.numberValue() != null && !other.numberValue().equals(this.numberValue())) {
            return false;
        }
        if (other.datetimeValue() == null ^ this.datetimeValue() == null) {
            return false;
        }
        return other.datetimeValue() == null || other.datetimeValue().equals(this.datetimeValue());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.stringValue() != null) {
            sb.append("StringValue: ").append(this.stringValue()).append(",");
        }
        if (this.binaryValue() != null) {
            sb.append("BinaryValue: ").append(this.binaryValue()).append(",");
        }
        if (this.booleanValue() != null) {
            sb.append("BooleanValue: ").append(this.booleanValue()).append(",");
        }
        if (this.numberValue() != null) {
            sb.append("NumberValue: ").append(this.numberValue()).append(",");
        }
        if (this.datetimeValue() != null) {
            sb.append("DatetimeValue: ").append(this.datetimeValue()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TypedAttributeValueMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String stringValue;
        private ByteBuffer binaryValue;
        private Boolean booleanValue;
        private String numberValue;
        private Date datetimeValue;

        private BuilderImpl() {
        }

        private BuilderImpl(TypedAttributeValue model) {
            this.setStringValue(model.stringValue);
            this.setBinaryValue(model.binaryValue);
            this.setBooleanValue(model.booleanValue);
            this.setNumberValue(model.numberValue);
            this.setDatetimeValue(model.datetimeValue);
        }

        public final String getStringValue() {
            return this.stringValue;
        }

        @Override
        public final Builder stringValue(String stringValue) {
            this.stringValue = stringValue;
            return this;
        }

        public final void setStringValue(String stringValue) {
            this.stringValue = stringValue;
        }

        public final ByteBuffer getBinaryValue() {
            return this.binaryValue;
        }

        @Override
        public final Builder binaryValue(ByteBuffer binaryValue) {
            this.binaryValue = StandardMemberCopier.copy((ByteBuffer)binaryValue);
            return this;
        }

        public final void setBinaryValue(ByteBuffer binaryValue) {
            this.binaryValue = StandardMemberCopier.copy((ByteBuffer)binaryValue);
        }

        public final Boolean getBooleanValue() {
            return this.booleanValue;
        }

        @Override
        public final Builder booleanValue(Boolean booleanValue) {
            this.booleanValue = booleanValue;
            return this;
        }

        public final void setBooleanValue(Boolean booleanValue) {
            this.booleanValue = booleanValue;
        }

        public final String getNumberValue() {
            return this.numberValue;
        }

        @Override
        public final Builder numberValue(String numberValue) {
            this.numberValue = numberValue;
            return this;
        }

        public final void setNumberValue(String numberValue) {
            this.numberValue = numberValue;
        }

        public final Date getDatetimeValue() {
            return this.datetimeValue;
        }

        @Override
        public final Builder datetimeValue(Date datetimeValue) {
            this.datetimeValue = StandardMemberCopier.copy((Date)datetimeValue);
            return this;
        }

        public final void setDatetimeValue(Date datetimeValue) {
            this.datetimeValue = StandardMemberCopier.copy((Date)datetimeValue);
        }

        public TypedAttributeValue build() {
            return new TypedAttributeValue(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, TypedAttributeValue> {
        public Builder stringValue(String var1);

        public Builder binaryValue(ByteBuffer var1);

        public Builder booleanValue(Boolean var1);

        public Builder numberValue(String var1);

        public Builder datetimeValue(Date var1);
    }
}

