/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.clouddirectory.model.ObjectIdentifierListCopier;
import software.amazon.awssdk.services.clouddirectory.transform.PathToObjectIdentifiersMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PathToObjectIdentifiers
implements StructuredPojo,
ToCopyableBuilder<Builder, PathToObjectIdentifiers> {
    private final String path;
    private final List<String> objectIdentifiers;

    private PathToObjectIdentifiers(BuilderImpl builder) {
        this.path = builder.path;
        this.objectIdentifiers = builder.objectIdentifiers;
    }

    public String path() {
        return this.path;
    }

    public List<String> objectIdentifiers() {
        return this.objectIdentifiers;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.path() == null ? 0 : this.path().hashCode());
        hashCode = 31 * hashCode + (this.objectIdentifiers() == null ? 0 : this.objectIdentifiers().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PathToObjectIdentifiers)) {
            return false;
        }
        PathToObjectIdentifiers other = (PathToObjectIdentifiers)obj;
        if (other.path() == null ^ this.path() == null) {
            return false;
        }
        if (other.path() != null && !other.path().equals(this.path())) {
            return false;
        }
        if (other.objectIdentifiers() == null ^ this.objectIdentifiers() == null) {
            return false;
        }
        return other.objectIdentifiers() == null || other.objectIdentifiers().equals(this.objectIdentifiers());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.path() != null) {
            sb.append("Path: ").append(this.path()).append(",");
        }
        if (this.objectIdentifiers() != null) {
            sb.append("ObjectIdentifiers: ").append(this.objectIdentifiers()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PathToObjectIdentifiersMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String path;
        private List<String> objectIdentifiers;

        private BuilderImpl() {
        }

        private BuilderImpl(PathToObjectIdentifiers model) {
            this.setPath(model.path);
            this.setObjectIdentifiers(model.objectIdentifiers);
        }

        public final String getPath() {
            return this.path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        public final Collection<String> getObjectIdentifiers() {
            return this.objectIdentifiers;
        }

        @Override
        public final Builder objectIdentifiers(Collection<String> objectIdentifiers) {
            this.objectIdentifiers = ObjectIdentifierListCopier.copy(objectIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder objectIdentifiers(String ... objectIdentifiers) {
            if (this.objectIdentifiers == null) {
                this.objectIdentifiers = new ArrayList<String>(objectIdentifiers.length);
            }
            for (String e : objectIdentifiers) {
                this.objectIdentifiers.add(e);
            }
            return this;
        }

        public final void setObjectIdentifiers(Collection<String> objectIdentifiers) {
            this.objectIdentifiers = ObjectIdentifierListCopier.copy(objectIdentifiers);
        }

        @SafeVarargs
        public final void setObjectIdentifiers(String ... objectIdentifiers) {
            if (this.objectIdentifiers == null) {
                this.objectIdentifiers = new ArrayList<String>(objectIdentifiers.length);
            }
            for (String e : objectIdentifiers) {
                this.objectIdentifiers.add(e);
            }
        }

        public PathToObjectIdentifiers build() {
            return new PathToObjectIdentifiers(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PathToObjectIdentifiers> {
        public Builder path(String var1);

        public Builder objectIdentifiers(Collection<String> var1);

        public Builder objectIdentifiers(String ... var1);
    }
}

