/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.clouddirectory.model.TypedLinkAttributeDefinition;
import software.amazon.awssdk.services.clouddirectory.model.TypedLinkAttributeDefinitionListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListTypedLinkFacetAttributesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListTypedLinkFacetAttributesResponse> {
    private final List<TypedLinkAttributeDefinition> attributes;
    private final String nextToken;

    private ListTypedLinkFacetAttributesResponse(BuilderImpl builder) {
        this.attributes = builder.attributes;
        this.nextToken = builder.nextToken;
    }

    public List<TypedLinkAttributeDefinition> attributes() {
        return this.attributes;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.attributes() == null ? 0 : this.attributes().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTypedLinkFacetAttributesResponse)) {
            return false;
        }
        ListTypedLinkFacetAttributesResponse other = (ListTypedLinkFacetAttributesResponse)((Object)obj);
        if (other.attributes() == null ^ this.attributes() == null) {
            return false;
        }
        if (other.attributes() != null && !other.attributes().equals(this.attributes())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.attributes() != null) {
            sb.append("Attributes: ").append(this.attributes()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<TypedLinkAttributeDefinition> attributes;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTypedLinkFacetAttributesResponse model) {
            this.setAttributes(model.attributes);
            this.setNextToken(model.nextToken);
        }

        public final Collection<TypedLinkAttributeDefinition> getAttributes() {
            return this.attributes;
        }

        @Override
        public final Builder attributes(Collection<TypedLinkAttributeDefinition> attributes) {
            this.attributes = TypedLinkAttributeDefinitionListCopier.copy(attributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(TypedLinkAttributeDefinition ... attributes) {
            if (this.attributes == null) {
                this.attributes = new ArrayList<TypedLinkAttributeDefinition>(attributes.length);
            }
            for (TypedLinkAttributeDefinition e : attributes) {
                this.attributes.add(e);
            }
            return this;
        }

        public final void setAttributes(Collection<TypedLinkAttributeDefinition> attributes) {
            this.attributes = TypedLinkAttributeDefinitionListCopier.copy(attributes);
        }

        @SafeVarargs
        public final void setAttributes(TypedLinkAttributeDefinition ... attributes) {
            if (this.attributes == null) {
                this.attributes = new ArrayList<TypedLinkAttributeDefinition>(attributes.length);
            }
            for (TypedLinkAttributeDefinition e : attributes) {
                this.attributes.add(e);
            }
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public ListTypedLinkFacetAttributesResponse build() {
            return new ListTypedLinkFacetAttributesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListTypedLinkFacetAttributesResponse> {
        public Builder attributes(Collection<TypedLinkAttributeDefinition> var1);

        public Builder attributes(TypedLinkAttributeDefinition ... var1);

        public Builder nextToken(String var1);
    }
}

