/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.clouddirectory.model.ObjectIdentifierListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListPolicyAttachmentsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListPolicyAttachmentsResponse> {
    private final List<String> objectIdentifiers;
    private final String nextToken;

    private ListPolicyAttachmentsResponse(BuilderImpl builder) {
        this.objectIdentifiers = builder.objectIdentifiers;
        this.nextToken = builder.nextToken;
    }

    public List<String> objectIdentifiers() {
        return this.objectIdentifiers;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.objectIdentifiers() == null ? 0 : this.objectIdentifiers().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPolicyAttachmentsResponse)) {
            return false;
        }
        ListPolicyAttachmentsResponse other = (ListPolicyAttachmentsResponse)((Object)obj);
        if (other.objectIdentifiers() == null ^ this.objectIdentifiers() == null) {
            return false;
        }
        if (other.objectIdentifiers() != null && !other.objectIdentifiers().equals(this.objectIdentifiers())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.objectIdentifiers() != null) {
            sb.append("ObjectIdentifiers: ").append(this.objectIdentifiers()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<String> objectIdentifiers;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPolicyAttachmentsResponse model) {
            this.setObjectIdentifiers(model.objectIdentifiers);
            this.setNextToken(model.nextToken);
        }

        public final Collection<String> getObjectIdentifiers() {
            return this.objectIdentifiers;
        }

        @Override
        public final Builder objectIdentifiers(Collection<String> objectIdentifiers) {
            this.objectIdentifiers = ObjectIdentifierListCopier.copy(objectIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder objectIdentifiers(String ... objectIdentifiers) {
            if (this.objectIdentifiers == null) {
                this.objectIdentifiers = new ArrayList<String>(objectIdentifiers.length);
            }
            for (String e : objectIdentifiers) {
                this.objectIdentifiers.add(e);
            }
            return this;
        }

        public final void setObjectIdentifiers(Collection<String> objectIdentifiers) {
            this.objectIdentifiers = ObjectIdentifierListCopier.copy(objectIdentifiers);
        }

        @SafeVarargs
        public final void setObjectIdentifiers(String ... objectIdentifiers) {
            if (this.objectIdentifiers == null) {
                this.objectIdentifiers = new ArrayList<String>(objectIdentifiers.length);
            }
            for (String e : objectIdentifiers) {
                this.objectIdentifiers.add(e);
            }
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public ListPolicyAttachmentsResponse build() {
            return new ListPolicyAttachmentsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListPolicyAttachmentsResponse> {
        public Builder objectIdentifiers(Collection<String> var1);

        public Builder objectIdentifiers(String ... var1);

        public Builder nextToken(String var1);
    }
}

