/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.clouddirectory.model.ConsistencyLevel;
import software.amazon.awssdk.services.clouddirectory.model.ObjectReference;
import software.amazon.awssdk.services.clouddirectory.model.TypedLinkAttributeRange;
import software.amazon.awssdk.services.clouddirectory.model.TypedLinkAttributeRangeListCopier;
import software.amazon.awssdk.services.clouddirectory.model.TypedLinkSchemaAndFacetName;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListOutgoingTypedLinksRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ListOutgoingTypedLinksRequest> {
    private final String directoryArn;
    private final ObjectReference objectReference;
    private final List<TypedLinkAttributeRange> filterAttributeRanges;
    private final TypedLinkSchemaAndFacetName filterTypedLink;
    private final String nextToken;
    private final Integer maxResults;
    private final String consistencyLevel;

    private ListOutgoingTypedLinksRequest(BuilderImpl builder) {
        this.directoryArn = builder.directoryArn;
        this.objectReference = builder.objectReference;
        this.filterAttributeRanges = builder.filterAttributeRanges;
        this.filterTypedLink = builder.filterTypedLink;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.consistencyLevel = builder.consistencyLevel;
    }

    public String directoryArn() {
        return this.directoryArn;
    }

    public ObjectReference objectReference() {
        return this.objectReference;
    }

    public List<TypedLinkAttributeRange> filterAttributeRanges() {
        return this.filterAttributeRanges;
    }

    public TypedLinkSchemaAndFacetName filterTypedLink() {
        return this.filterTypedLink;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public String consistencyLevel() {
        return this.consistencyLevel;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.directoryArn() == null ? 0 : this.directoryArn().hashCode());
        hashCode = 31 * hashCode + (this.objectReference() == null ? 0 : this.objectReference().hashCode());
        hashCode = 31 * hashCode + (this.filterAttributeRanges() == null ? 0 : this.filterAttributeRanges().hashCode());
        hashCode = 31 * hashCode + (this.filterTypedLink() == null ? 0 : this.filterTypedLink().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        hashCode = 31 * hashCode + (this.maxResults() == null ? 0 : this.maxResults().hashCode());
        hashCode = 31 * hashCode + (this.consistencyLevel() == null ? 0 : this.consistencyLevel().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListOutgoingTypedLinksRequest)) {
            return false;
        }
        ListOutgoingTypedLinksRequest other = (ListOutgoingTypedLinksRequest)((Object)obj);
        if (other.directoryArn() == null ^ this.directoryArn() == null) {
            return false;
        }
        if (other.directoryArn() != null && !other.directoryArn().equals(this.directoryArn())) {
            return false;
        }
        if (other.objectReference() == null ^ this.objectReference() == null) {
            return false;
        }
        if (other.objectReference() != null && !other.objectReference().equals(this.objectReference())) {
            return false;
        }
        if (other.filterAttributeRanges() == null ^ this.filterAttributeRanges() == null) {
            return false;
        }
        if (other.filterAttributeRanges() != null && !other.filterAttributeRanges().equals(this.filterAttributeRanges())) {
            return false;
        }
        if (other.filterTypedLink() == null ^ this.filterTypedLink() == null) {
            return false;
        }
        if (other.filterTypedLink() != null && !other.filterTypedLink().equals(this.filterTypedLink())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        if (other.maxResults() == null ^ this.maxResults() == null) {
            return false;
        }
        if (other.maxResults() != null && !other.maxResults().equals(this.maxResults())) {
            return false;
        }
        if (other.consistencyLevel() == null ^ this.consistencyLevel() == null) {
            return false;
        }
        return other.consistencyLevel() == null || other.consistencyLevel().equals(this.consistencyLevel());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.directoryArn() != null) {
            sb.append("DirectoryArn: ").append(this.directoryArn()).append(",");
        }
        if (this.objectReference() != null) {
            sb.append("ObjectReference: ").append(this.objectReference()).append(",");
        }
        if (this.filterAttributeRanges() != null) {
            sb.append("FilterAttributeRanges: ").append(this.filterAttributeRanges()).append(",");
        }
        if (this.filterTypedLink() != null) {
            sb.append("FilterTypedLink: ").append(this.filterTypedLink()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (this.maxResults() != null) {
            sb.append("MaxResults: ").append(this.maxResults()).append(",");
        }
        if (this.consistencyLevel() != null) {
            sb.append("ConsistencyLevel: ").append(this.consistencyLevel()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String directoryArn;
        private ObjectReference objectReference;
        private List<TypedLinkAttributeRange> filterAttributeRanges;
        private TypedLinkSchemaAndFacetName filterTypedLink;
        private String nextToken;
        private Integer maxResults;
        private String consistencyLevel;

        private BuilderImpl() {
        }

        private BuilderImpl(ListOutgoingTypedLinksRequest model) {
            this.setDirectoryArn(model.directoryArn);
            this.setObjectReference(model.objectReference);
            this.setFilterAttributeRanges(model.filterAttributeRanges);
            this.setFilterTypedLink(model.filterTypedLink);
            this.setNextToken(model.nextToken);
            this.setMaxResults(model.maxResults);
            this.setConsistencyLevel(model.consistencyLevel);
        }

        public final String getDirectoryArn() {
            return this.directoryArn;
        }

        @Override
        public final Builder directoryArn(String directoryArn) {
            this.directoryArn = directoryArn;
            return this;
        }

        public final void setDirectoryArn(String directoryArn) {
            this.directoryArn = directoryArn;
        }

        public final ObjectReference getObjectReference() {
            return this.objectReference;
        }

        @Override
        public final Builder objectReference(ObjectReference objectReference) {
            this.objectReference = objectReference;
            return this;
        }

        public final void setObjectReference(ObjectReference objectReference) {
            this.objectReference = objectReference;
        }

        public final Collection<TypedLinkAttributeRange> getFilterAttributeRanges() {
            return this.filterAttributeRanges;
        }

        @Override
        public final Builder filterAttributeRanges(Collection<TypedLinkAttributeRange> filterAttributeRanges) {
            this.filterAttributeRanges = TypedLinkAttributeRangeListCopier.copy(filterAttributeRanges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filterAttributeRanges(TypedLinkAttributeRange ... filterAttributeRanges) {
            if (this.filterAttributeRanges == null) {
                this.filterAttributeRanges = new ArrayList<TypedLinkAttributeRange>(filterAttributeRanges.length);
            }
            for (TypedLinkAttributeRange e : filterAttributeRanges) {
                this.filterAttributeRanges.add(e);
            }
            return this;
        }

        public final void setFilterAttributeRanges(Collection<TypedLinkAttributeRange> filterAttributeRanges) {
            this.filterAttributeRanges = TypedLinkAttributeRangeListCopier.copy(filterAttributeRanges);
        }

        @SafeVarargs
        public final void setFilterAttributeRanges(TypedLinkAttributeRange ... filterAttributeRanges) {
            if (this.filterAttributeRanges == null) {
                this.filterAttributeRanges = new ArrayList<TypedLinkAttributeRange>(filterAttributeRanges.length);
            }
            for (TypedLinkAttributeRange e : filterAttributeRanges) {
                this.filterAttributeRanges.add(e);
            }
        }

        public final TypedLinkSchemaAndFacetName getFilterTypedLink() {
            return this.filterTypedLink;
        }

        @Override
        public final Builder filterTypedLink(TypedLinkSchemaAndFacetName filterTypedLink) {
            this.filterTypedLink = filterTypedLink;
            return this;
        }

        public final void setFilterTypedLink(TypedLinkSchemaAndFacetName filterTypedLink) {
            this.filterTypedLink = filterTypedLink;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getConsistencyLevel() {
            return this.consistencyLevel;
        }

        @Override
        public final Builder consistencyLevel(String consistencyLevel) {
            this.consistencyLevel = consistencyLevel;
            return this;
        }

        @Override
        public final Builder consistencyLevel(ConsistencyLevel consistencyLevel) {
            this.consistencyLevel(consistencyLevel.toString());
            return this;
        }

        public final void setConsistencyLevel(String consistencyLevel) {
            this.consistencyLevel = consistencyLevel;
        }

        public final void setConsistencyLevel(ConsistencyLevel consistencyLevel) {
            this.consistencyLevel(consistencyLevel.toString());
        }

        public ListOutgoingTypedLinksRequest build() {
            return new ListOutgoingTypedLinksRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListOutgoingTypedLinksRequest> {
        public Builder directoryArn(String var1);

        public Builder objectReference(ObjectReference var1);

        public Builder filterAttributeRanges(Collection<TypedLinkAttributeRange> var1);

        public Builder filterAttributeRanges(TypedLinkAttributeRange ... var1);

        public Builder filterTypedLink(TypedLinkSchemaAndFacetName var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder consistencyLevel(String var1);

        public Builder consistencyLevel(ConsistencyLevel var1);
    }
}

