/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.clouddirectory.model.ConsistencyLevel;
import software.amazon.awssdk.services.clouddirectory.model.ObjectAttributeRange;
import software.amazon.awssdk.services.clouddirectory.model.ObjectAttributeRangeListCopier;
import software.amazon.awssdk.services.clouddirectory.model.ObjectReference;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListIndexRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ListIndexRequest> {
    private final String directoryArn;
    private final List<ObjectAttributeRange> rangesOnIndexedValues;
    private final ObjectReference indexReference;
    private final Integer maxResults;
    private final String nextToken;
    private final String consistencyLevel;

    private ListIndexRequest(BuilderImpl builder) {
        this.directoryArn = builder.directoryArn;
        this.rangesOnIndexedValues = builder.rangesOnIndexedValues;
        this.indexReference = builder.indexReference;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.consistencyLevel = builder.consistencyLevel;
    }

    public String directoryArn() {
        return this.directoryArn;
    }

    public List<ObjectAttributeRange> rangesOnIndexedValues() {
        return this.rangesOnIndexedValues;
    }

    public ObjectReference indexReference() {
        return this.indexReference;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public String consistencyLevel() {
        return this.consistencyLevel;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.directoryArn() == null ? 0 : this.directoryArn().hashCode());
        hashCode = 31 * hashCode + (this.rangesOnIndexedValues() == null ? 0 : this.rangesOnIndexedValues().hashCode());
        hashCode = 31 * hashCode + (this.indexReference() == null ? 0 : this.indexReference().hashCode());
        hashCode = 31 * hashCode + (this.maxResults() == null ? 0 : this.maxResults().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        hashCode = 31 * hashCode + (this.consistencyLevel() == null ? 0 : this.consistencyLevel().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListIndexRequest)) {
            return false;
        }
        ListIndexRequest other = (ListIndexRequest)((Object)obj);
        if (other.directoryArn() == null ^ this.directoryArn() == null) {
            return false;
        }
        if (other.directoryArn() != null && !other.directoryArn().equals(this.directoryArn())) {
            return false;
        }
        if (other.rangesOnIndexedValues() == null ^ this.rangesOnIndexedValues() == null) {
            return false;
        }
        if (other.rangesOnIndexedValues() != null && !other.rangesOnIndexedValues().equals(this.rangesOnIndexedValues())) {
            return false;
        }
        if (other.indexReference() == null ^ this.indexReference() == null) {
            return false;
        }
        if (other.indexReference() != null && !other.indexReference().equals(this.indexReference())) {
            return false;
        }
        if (other.maxResults() == null ^ this.maxResults() == null) {
            return false;
        }
        if (other.maxResults() != null && !other.maxResults().equals(this.maxResults())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        if (other.consistencyLevel() == null ^ this.consistencyLevel() == null) {
            return false;
        }
        return other.consistencyLevel() == null || other.consistencyLevel().equals(this.consistencyLevel());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.directoryArn() != null) {
            sb.append("DirectoryArn: ").append(this.directoryArn()).append(",");
        }
        if (this.rangesOnIndexedValues() != null) {
            sb.append("RangesOnIndexedValues: ").append(this.rangesOnIndexedValues()).append(",");
        }
        if (this.indexReference() != null) {
            sb.append("IndexReference: ").append(this.indexReference()).append(",");
        }
        if (this.maxResults() != null) {
            sb.append("MaxResults: ").append(this.maxResults()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (this.consistencyLevel() != null) {
            sb.append("ConsistencyLevel: ").append(this.consistencyLevel()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String directoryArn;
        private List<ObjectAttributeRange> rangesOnIndexedValues;
        private ObjectReference indexReference;
        private Integer maxResults;
        private String nextToken;
        private String consistencyLevel;

        private BuilderImpl() {
        }

        private BuilderImpl(ListIndexRequest model) {
            this.setDirectoryArn(model.directoryArn);
            this.setRangesOnIndexedValues(model.rangesOnIndexedValues);
            this.setIndexReference(model.indexReference);
            this.setMaxResults(model.maxResults);
            this.setNextToken(model.nextToken);
            this.setConsistencyLevel(model.consistencyLevel);
        }

        public final String getDirectoryArn() {
            return this.directoryArn;
        }

        @Override
        public final Builder directoryArn(String directoryArn) {
            this.directoryArn = directoryArn;
            return this;
        }

        public final void setDirectoryArn(String directoryArn) {
            this.directoryArn = directoryArn;
        }

        public final Collection<ObjectAttributeRange> getRangesOnIndexedValues() {
            return this.rangesOnIndexedValues;
        }

        @Override
        public final Builder rangesOnIndexedValues(Collection<ObjectAttributeRange> rangesOnIndexedValues) {
            this.rangesOnIndexedValues = ObjectAttributeRangeListCopier.copy(rangesOnIndexedValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rangesOnIndexedValues(ObjectAttributeRange ... rangesOnIndexedValues) {
            if (this.rangesOnIndexedValues == null) {
                this.rangesOnIndexedValues = new ArrayList<ObjectAttributeRange>(rangesOnIndexedValues.length);
            }
            for (ObjectAttributeRange e : rangesOnIndexedValues) {
                this.rangesOnIndexedValues.add(e);
            }
            return this;
        }

        public final void setRangesOnIndexedValues(Collection<ObjectAttributeRange> rangesOnIndexedValues) {
            this.rangesOnIndexedValues = ObjectAttributeRangeListCopier.copy(rangesOnIndexedValues);
        }

        @SafeVarargs
        public final void setRangesOnIndexedValues(ObjectAttributeRange ... rangesOnIndexedValues) {
            if (this.rangesOnIndexedValues == null) {
                this.rangesOnIndexedValues = new ArrayList<ObjectAttributeRange>(rangesOnIndexedValues.length);
            }
            for (ObjectAttributeRange e : rangesOnIndexedValues) {
                this.rangesOnIndexedValues.add(e);
            }
        }

        public final ObjectReference getIndexReference() {
            return this.indexReference;
        }

        @Override
        public final Builder indexReference(ObjectReference indexReference) {
            this.indexReference = indexReference;
            return this;
        }

        public final void setIndexReference(ObjectReference indexReference) {
            this.indexReference = indexReference;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final String getConsistencyLevel() {
            return this.consistencyLevel;
        }

        @Override
        public final Builder consistencyLevel(String consistencyLevel) {
            this.consistencyLevel = consistencyLevel;
            return this;
        }

        @Override
        public final Builder consistencyLevel(ConsistencyLevel consistencyLevel) {
            this.consistencyLevel(consistencyLevel.toString());
            return this;
        }

        public final void setConsistencyLevel(String consistencyLevel) {
            this.consistencyLevel = consistencyLevel;
        }

        public final void setConsistencyLevel(ConsistencyLevel consistencyLevel) {
            this.consistencyLevel(consistencyLevel.toString());
        }

        public ListIndexRequest build() {
            return new ListIndexRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListIndexRequest> {
        public Builder directoryArn(String var1);

        public Builder rangesOnIndexedValues(Collection<ObjectAttributeRange> var1);

        public Builder rangesOnIndexedValues(ObjectAttributeRange ... var1);

        public Builder indexReference(ObjectReference var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder consistencyLevel(String var1);

        public Builder consistencyLevel(ConsistencyLevel var1);
    }
}

