/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.clouddirectory.model.Directory;
import software.amazon.awssdk.services.clouddirectory.model.DirectoryListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListDirectoriesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListDirectoriesResponse> {
    private final List<Directory> directories;
    private final String nextToken;

    private ListDirectoriesResponse(BuilderImpl builder) {
        this.directories = builder.directories;
        this.nextToken = builder.nextToken;
    }

    public List<Directory> directories() {
        return this.directories;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.directories() == null ? 0 : this.directories().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDirectoriesResponse)) {
            return false;
        }
        ListDirectoriesResponse other = (ListDirectoriesResponse)((Object)obj);
        if (other.directories() == null ^ this.directories() == null) {
            return false;
        }
        if (other.directories() != null && !other.directories().equals(this.directories())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.directories() != null) {
            sb.append("Directories: ").append(this.directories()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<Directory> directories;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDirectoriesResponse model) {
            this.setDirectories(model.directories);
            this.setNextToken(model.nextToken);
        }

        public final Collection<Directory> getDirectories() {
            return this.directories;
        }

        @Override
        public final Builder directories(Collection<Directory> directories) {
            this.directories = DirectoryListCopier.copy(directories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder directories(Directory ... directories) {
            if (this.directories == null) {
                this.directories = new ArrayList<Directory>(directories.length);
            }
            for (Directory e : directories) {
                this.directories.add(e);
            }
            return this;
        }

        public final void setDirectories(Collection<Directory> directories) {
            this.directories = DirectoryListCopier.copy(directories);
        }

        @SafeVarargs
        public final void setDirectories(Directory ... directories) {
            if (this.directories == null) {
                this.directories = new ArrayList<Directory>(directories.length);
            }
            for (Directory e : directories) {
                this.directories.add(e);
            }
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public ListDirectoriesResponse build() {
            return new ListDirectoriesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListDirectoriesResponse> {
        public Builder directories(Collection<Directory> var1);

        public Builder directories(Directory ... var1);

        public Builder nextToken(String var1);
    }
}

