/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.clouddirectory.model.FacetAttribute;
import software.amazon.awssdk.services.clouddirectory.model.FacetAttributeListCopier;
import software.amazon.awssdk.services.clouddirectory.model.ObjectType;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateFacetRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreateFacetRequest> {
    private final String schemaArn;
    private final String name;
    private final List<FacetAttribute> attributes;
    private final String objectType;

    private CreateFacetRequest(BuilderImpl builder) {
        this.schemaArn = builder.schemaArn;
        this.name = builder.name;
        this.attributes = builder.attributes;
        this.objectType = builder.objectType;
    }

    public String schemaArn() {
        return this.schemaArn;
    }

    public String name() {
        return this.name;
    }

    public List<FacetAttribute> attributes() {
        return this.attributes;
    }

    public String objectType() {
        return this.objectType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.schemaArn() == null ? 0 : this.schemaArn().hashCode());
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.attributes() == null ? 0 : this.attributes().hashCode());
        hashCode = 31 * hashCode + (this.objectType() == null ? 0 : this.objectType().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFacetRequest)) {
            return false;
        }
        CreateFacetRequest other = (CreateFacetRequest)((Object)obj);
        if (other.schemaArn() == null ^ this.schemaArn() == null) {
            return false;
        }
        if (other.schemaArn() != null && !other.schemaArn().equals(this.schemaArn())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.attributes() == null ^ this.attributes() == null) {
            return false;
        }
        if (other.attributes() != null && !other.attributes().equals(this.attributes())) {
            return false;
        }
        if (other.objectType() == null ^ this.objectType() == null) {
            return false;
        }
        return other.objectType() == null || other.objectType().equals(this.objectType());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.schemaArn() != null) {
            sb.append("SchemaArn: ").append(this.schemaArn()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.attributes() != null) {
            sb.append("Attributes: ").append(this.attributes()).append(",");
        }
        if (this.objectType() != null) {
            sb.append("ObjectType: ").append(this.objectType()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String schemaArn;
        private String name;
        private List<FacetAttribute> attributes;
        private String objectType;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFacetRequest model) {
            this.setSchemaArn(model.schemaArn);
            this.setName(model.name);
            this.setAttributes(model.attributes);
            this.setObjectType(model.objectType);
        }

        public final String getSchemaArn() {
            return this.schemaArn;
        }

        @Override
        public final Builder schemaArn(String schemaArn) {
            this.schemaArn = schemaArn;
            return this;
        }

        public final void setSchemaArn(String schemaArn) {
            this.schemaArn = schemaArn;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<FacetAttribute> getAttributes() {
            return this.attributes;
        }

        @Override
        public final Builder attributes(Collection<FacetAttribute> attributes) {
            this.attributes = FacetAttributeListCopier.copy(attributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(FacetAttribute ... attributes) {
            if (this.attributes == null) {
                this.attributes = new ArrayList<FacetAttribute>(attributes.length);
            }
            for (FacetAttribute e : attributes) {
                this.attributes.add(e);
            }
            return this;
        }

        public final void setAttributes(Collection<FacetAttribute> attributes) {
            this.attributes = FacetAttributeListCopier.copy(attributes);
        }

        @SafeVarargs
        public final void setAttributes(FacetAttribute ... attributes) {
            if (this.attributes == null) {
                this.attributes = new ArrayList<FacetAttribute>(attributes.length);
            }
            for (FacetAttribute e : attributes) {
                this.attributes.add(e);
            }
        }

        public final String getObjectType() {
            return this.objectType;
        }

        @Override
        public final Builder objectType(String objectType) {
            this.objectType = objectType;
            return this;
        }

        @Override
        public final Builder objectType(ObjectType objectType) {
            this.objectType(objectType.toString());
            return this;
        }

        public final void setObjectType(String objectType) {
            this.objectType = objectType;
        }

        public final void setObjectType(ObjectType objectType) {
            this.objectType(objectType.toString());
        }

        public CreateFacetRequest build() {
            return new CreateFacetRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateFacetRequest> {
        public Builder schemaArn(String var1);

        public Builder name(String var1);

        public Builder attributes(Collection<FacetAttribute> var1);

        public Builder attributes(FacetAttribute ... var1);

        public Builder objectType(String var1);

        public Builder objectType(ObjectType var1);
    }
}

