/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.clouddirectory.model.AttributeKeyAndValue;
import software.amazon.awssdk.services.clouddirectory.model.AttributeKeyAndValueListCopier;
import software.amazon.awssdk.services.clouddirectory.model.ObjectReference;
import software.amazon.awssdk.services.clouddirectory.model.SchemaFacet;
import software.amazon.awssdk.services.clouddirectory.model.SchemaFacetListCopier;
import software.amazon.awssdk.services.clouddirectory.transform.BatchCreateObjectMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class BatchCreateObject
implements StructuredPojo,
ToCopyableBuilder<Builder, BatchCreateObject> {
    private final List<SchemaFacet> schemaFacet;
    private final List<AttributeKeyAndValue> objectAttributeList;
    private final ObjectReference parentReference;
    private final String linkName;
    private final String batchReferenceName;

    private BatchCreateObject(BuilderImpl builder) {
        this.schemaFacet = builder.schemaFacet;
        this.objectAttributeList = builder.objectAttributeList;
        this.parentReference = builder.parentReference;
        this.linkName = builder.linkName;
        this.batchReferenceName = builder.batchReferenceName;
    }

    public List<SchemaFacet> schemaFacet() {
        return this.schemaFacet;
    }

    public List<AttributeKeyAndValue> objectAttributeList() {
        return this.objectAttributeList;
    }

    public ObjectReference parentReference() {
        return this.parentReference;
    }

    public String linkName() {
        return this.linkName;
    }

    public String batchReferenceName() {
        return this.batchReferenceName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.schemaFacet() == null ? 0 : this.schemaFacet().hashCode());
        hashCode = 31 * hashCode + (this.objectAttributeList() == null ? 0 : this.objectAttributeList().hashCode());
        hashCode = 31 * hashCode + (this.parentReference() == null ? 0 : this.parentReference().hashCode());
        hashCode = 31 * hashCode + (this.linkName() == null ? 0 : this.linkName().hashCode());
        hashCode = 31 * hashCode + (this.batchReferenceName() == null ? 0 : this.batchReferenceName().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchCreateObject)) {
            return false;
        }
        BatchCreateObject other = (BatchCreateObject)obj;
        if (other.schemaFacet() == null ^ this.schemaFacet() == null) {
            return false;
        }
        if (other.schemaFacet() != null && !other.schemaFacet().equals(this.schemaFacet())) {
            return false;
        }
        if (other.objectAttributeList() == null ^ this.objectAttributeList() == null) {
            return false;
        }
        if (other.objectAttributeList() != null && !other.objectAttributeList().equals(this.objectAttributeList())) {
            return false;
        }
        if (other.parentReference() == null ^ this.parentReference() == null) {
            return false;
        }
        if (other.parentReference() != null && !other.parentReference().equals(this.parentReference())) {
            return false;
        }
        if (other.linkName() == null ^ this.linkName() == null) {
            return false;
        }
        if (other.linkName() != null && !other.linkName().equals(this.linkName())) {
            return false;
        }
        if (other.batchReferenceName() == null ^ this.batchReferenceName() == null) {
            return false;
        }
        return other.batchReferenceName() == null || other.batchReferenceName().equals(this.batchReferenceName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.schemaFacet() != null) {
            sb.append("SchemaFacet: ").append(this.schemaFacet()).append(",");
        }
        if (this.objectAttributeList() != null) {
            sb.append("ObjectAttributeList: ").append(this.objectAttributeList()).append(",");
        }
        if (this.parentReference() != null) {
            sb.append("ParentReference: ").append(this.parentReference()).append(",");
        }
        if (this.linkName() != null) {
            sb.append("LinkName: ").append(this.linkName()).append(",");
        }
        if (this.batchReferenceName() != null) {
            sb.append("BatchReferenceName: ").append(this.batchReferenceName()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BatchCreateObjectMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private List<SchemaFacet> schemaFacet;
        private List<AttributeKeyAndValue> objectAttributeList;
        private ObjectReference parentReference;
        private String linkName;
        private String batchReferenceName;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchCreateObject model) {
            this.setSchemaFacet(model.schemaFacet);
            this.setObjectAttributeList(model.objectAttributeList);
            this.setParentReference(model.parentReference);
            this.setLinkName(model.linkName);
            this.setBatchReferenceName(model.batchReferenceName);
        }

        public final Collection<SchemaFacet> getSchemaFacet() {
            return this.schemaFacet;
        }

        @Override
        public final Builder schemaFacet(Collection<SchemaFacet> schemaFacet) {
            this.schemaFacet = SchemaFacetListCopier.copy(schemaFacet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder schemaFacet(SchemaFacet ... schemaFacet) {
            if (this.schemaFacet == null) {
                this.schemaFacet = new ArrayList<SchemaFacet>(schemaFacet.length);
            }
            for (SchemaFacet e : schemaFacet) {
                this.schemaFacet.add(e);
            }
            return this;
        }

        public final void setSchemaFacet(Collection<SchemaFacet> schemaFacet) {
            this.schemaFacet = SchemaFacetListCopier.copy(schemaFacet);
        }

        @SafeVarargs
        public final void setSchemaFacet(SchemaFacet ... schemaFacet) {
            if (this.schemaFacet == null) {
                this.schemaFacet = new ArrayList<SchemaFacet>(schemaFacet.length);
            }
            for (SchemaFacet e : schemaFacet) {
                this.schemaFacet.add(e);
            }
        }

        public final Collection<AttributeKeyAndValue> getObjectAttributeList() {
            return this.objectAttributeList;
        }

        @Override
        public final Builder objectAttributeList(Collection<AttributeKeyAndValue> objectAttributeList) {
            this.objectAttributeList = AttributeKeyAndValueListCopier.copy(objectAttributeList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder objectAttributeList(AttributeKeyAndValue ... objectAttributeList) {
            if (this.objectAttributeList == null) {
                this.objectAttributeList = new ArrayList<AttributeKeyAndValue>(objectAttributeList.length);
            }
            for (AttributeKeyAndValue e : objectAttributeList) {
                this.objectAttributeList.add(e);
            }
            return this;
        }

        public final void setObjectAttributeList(Collection<AttributeKeyAndValue> objectAttributeList) {
            this.objectAttributeList = AttributeKeyAndValueListCopier.copy(objectAttributeList);
        }

        @SafeVarargs
        public final void setObjectAttributeList(AttributeKeyAndValue ... objectAttributeList) {
            if (this.objectAttributeList == null) {
                this.objectAttributeList = new ArrayList<AttributeKeyAndValue>(objectAttributeList.length);
            }
            for (AttributeKeyAndValue e : objectAttributeList) {
                this.objectAttributeList.add(e);
            }
        }

        public final ObjectReference getParentReference() {
            return this.parentReference;
        }

        @Override
        public final Builder parentReference(ObjectReference parentReference) {
            this.parentReference = parentReference;
            return this;
        }

        public final void setParentReference(ObjectReference parentReference) {
            this.parentReference = parentReference;
        }

        public final String getLinkName() {
            return this.linkName;
        }

        @Override
        public final Builder linkName(String linkName) {
            this.linkName = linkName;
            return this;
        }

        public final void setLinkName(String linkName) {
            this.linkName = linkName;
        }

        public final String getBatchReferenceName() {
            return this.batchReferenceName;
        }

        @Override
        public final Builder batchReferenceName(String batchReferenceName) {
            this.batchReferenceName = batchReferenceName;
            return this;
        }

        public final void setBatchReferenceName(String batchReferenceName) {
            this.batchReferenceName = batchReferenceName;
        }

        public BatchCreateObject build() {
            return new BatchCreateObject(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, BatchCreateObject> {
        public Builder schemaFacet(Collection<SchemaFacet> var1);

        public Builder schemaFacet(SchemaFacet ... var1);

        public Builder objectAttributeList(Collection<AttributeKeyAndValue> var1);

        public Builder objectAttributeList(AttributeKeyAndValue ... var1);

        public Builder parentReference(ObjectReference var1);

        public Builder linkName(String var1);

        public Builder batchReferenceName(String var1);
    }
}

