/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudcontrol.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListResourceRequestsResponse extends CloudControlResponse implements
        ToCopyableBuilder<ListResourceRequestsResponse.Builder, ListResourceRequestsResponse> {
    private static final SdkField<List<ProgressEvent>> RESOURCE_REQUEST_STATUS_SUMMARIES_FIELD = SdkField
            .<List<ProgressEvent>> builder(MarshallingType.LIST)
            .memberName("ResourceRequestStatusSummaries")
            .getter(getter(ListResourceRequestsResponse::resourceRequestStatusSummaries))
            .setter(setter(Builder::resourceRequestStatusSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceRequestStatusSummaries")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ProgressEvent> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProgressEvent::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListResourceRequestsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            RESOURCE_REQUEST_STATUS_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<ProgressEvent> resourceRequestStatusSummaries;

    private final String nextToken;

    private ListResourceRequestsResponse(BuilderImpl builder) {
        super(builder);
        this.resourceRequestStatusSummaries = builder.resourceRequestStatusSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourceRequestStatusSummaries property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasResourceRequestStatusSummaries() {
        return resourceRequestStatusSummaries != null && !(resourceRequestStatusSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The requests that match the specified filter criteria.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceRequestStatusSummaries} method.
     * </p>
     * 
     * @return The requests that match the specified filter criteria.
     */
    public final List<ProgressEvent> resourceRequestStatusSummaries() {
        return resourceRequestStatusSummaries;
    }

    /**
     * <p>
     * If the request doesn't return all of the remaining results, <code>NextToken</code> is set to a token. To retrieve
     * the next set of results, call <code>ListResources</code> again and assign that token to the request object's
     * <code>NextToken</code> parameter. If the request returns all results, <code>NextToken</code> is set to null.
     * </p>
     * 
     * @return If the request doesn't return all of the remaining results, <code>NextToken</code> is set to a token. To
     *         retrieve the next set of results, call <code>ListResources</code> again and assign that token to the
     *         request object's <code>NextToken</code> parameter. If the request returns all results,
     *         <code>NextToken</code> is set to null.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode
                + Objects.hashCode(hasResourceRequestStatusSummaries() ? resourceRequestStatusSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListResourceRequestsResponse)) {
            return false;
        }
        ListResourceRequestsResponse other = (ListResourceRequestsResponse) obj;
        return hasResourceRequestStatusSummaries() == other.hasResourceRequestStatusSummaries()
                && Objects.equals(resourceRequestStatusSummaries(), other.resourceRequestStatusSummaries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("ListResourceRequestsResponse")
                .add("ResourceRequestStatusSummaries",
                        hasResourceRequestStatusSummaries() ? resourceRequestStatusSummaries() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceRequestStatusSummaries":
            return Optional.ofNullable(clazz.cast(resourceRequestStatusSummaries()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ResourceRequestStatusSummaries", RESOURCE_REQUEST_STATUS_SUMMARIES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListResourceRequestsResponse, T> g) {
        return obj -> g.apply((ListResourceRequestsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CloudControlResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListResourceRequestsResponse> {
        /**
         * <p>
         * The requests that match the specified filter criteria.
         * </p>
         * 
         * @param resourceRequestStatusSummaries
         *        The requests that match the specified filter criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceRequestStatusSummaries(Collection<ProgressEvent> resourceRequestStatusSummaries);

        /**
         * <p>
         * The requests that match the specified filter criteria.
         * </p>
         * 
         * @param resourceRequestStatusSummaries
         *        The requests that match the specified filter criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceRequestStatusSummaries(ProgressEvent... resourceRequestStatusSummaries);

        /**
         * <p>
         * The requests that match the specified filter criteria.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cloudcontrol.model.ProgressEvent.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.cloudcontrol.model.ProgressEvent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cloudcontrol.model.ProgressEvent.Builder#build()} is called
         * immediately and its result is passed to {@link #resourceRequestStatusSummaries(List<ProgressEvent>)}.
         * 
         * @param resourceRequestStatusSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cloudcontrol.model.ProgressEvent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceRequestStatusSummaries(java.util.Collection<ProgressEvent>)
         */
        Builder resourceRequestStatusSummaries(Consumer<ProgressEvent.Builder>... resourceRequestStatusSummaries);

        /**
         * <p>
         * If the request doesn't return all of the remaining results, <code>NextToken</code> is set to a token. To
         * retrieve the next set of results, call <code>ListResources</code> again and assign that token to the request
         * object's <code>NextToken</code> parameter. If the request returns all results, <code>NextToken</code> is set
         * to null.
         * </p>
         * 
         * @param nextToken
         *        If the request doesn't return all of the remaining results, <code>NextToken</code> is set to a token.
         *        To retrieve the next set of results, call <code>ListResources</code> again and assign that token to
         *        the request object's <code>NextToken</code> parameter. If the request returns all results,
         *        <code>NextToken</code> is set to null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CloudControlResponse.BuilderImpl implements Builder {
        private List<ProgressEvent> resourceRequestStatusSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListResourceRequestsResponse model) {
            super(model);
            resourceRequestStatusSummaries(model.resourceRequestStatusSummaries);
            nextToken(model.nextToken);
        }

        public final List<ProgressEvent.Builder> getResourceRequestStatusSummaries() {
            List<ProgressEvent.Builder> result = ResourceRequestStatusSummariesCopier
                    .copyToBuilder(this.resourceRequestStatusSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceRequestStatusSummaries(Collection<ProgressEvent.BuilderImpl> resourceRequestStatusSummaries) {
            this.resourceRequestStatusSummaries = ResourceRequestStatusSummariesCopier
                    .copyFromBuilder(resourceRequestStatusSummaries);
        }

        @Override
        public final Builder resourceRequestStatusSummaries(Collection<ProgressEvent> resourceRequestStatusSummaries) {
            this.resourceRequestStatusSummaries = ResourceRequestStatusSummariesCopier.copy(resourceRequestStatusSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceRequestStatusSummaries(ProgressEvent... resourceRequestStatusSummaries) {
            resourceRequestStatusSummaries(Arrays.asList(resourceRequestStatusSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceRequestStatusSummaries(Consumer<ProgressEvent.Builder>... resourceRequestStatusSummaries) {
            resourceRequestStatusSummaries(Stream.of(resourceRequestStatusSummaries)
                    .map(c -> ProgressEvent.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListResourceRequestsResponse build() {
            return new ListResourceRequestsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
