/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudcontrol.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudcontrol.model.CloudControlRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateResourceRequest
extends CloudControlRequest
implements ToCopyableBuilder<Builder, UpdateResourceRequest> {
    private static final SdkField<String> TYPE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TypeName").getter(UpdateResourceRequest.getter(UpdateResourceRequest::typeName)).setter(UpdateResourceRequest.setter(Builder::typeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeName").build()}).build();
    private static final SdkField<String> TYPE_VERSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TypeVersionId").getter(UpdateResourceRequest.getter(UpdateResourceRequest::typeVersionId)).setter(UpdateResourceRequest.setter(Builder::typeVersionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeVersionId").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(UpdateResourceRequest.getter(UpdateResourceRequest::roleArn)).setter(UpdateResourceRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(UpdateResourceRequest.getter(UpdateResourceRequest::clientToken)).setter(UpdateResourceRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Identifier").getter(UpdateResourceRequest.getter(UpdateResourceRequest::identifier)).setter(UpdateResourceRequest.setter(Builder::identifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Identifier").build()}).build();
    private static final SdkField<String> PATCH_DOCUMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PatchDocument").getter(UpdateResourceRequest.getter(UpdateResourceRequest::patchDocument)).setter(UpdateResourceRequest.setter(Builder::patchDocument)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PatchDocument").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_NAME_FIELD, TYPE_VERSION_ID_FIELD, ROLE_ARN_FIELD, CLIENT_TOKEN_FIELD, IDENTIFIER_FIELD, PATCH_DOCUMENT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateResourceRequest.memberNameToFieldInitializer();
    private final String typeName;
    private final String typeVersionId;
    private final String roleArn;
    private final String clientToken;
    private final String identifier;
    private final String patchDocument;

    private UpdateResourceRequest(BuilderImpl builder) {
        super(builder);
        this.typeName = builder.typeName;
        this.typeVersionId = builder.typeVersionId;
        this.roleArn = builder.roleArn;
        this.clientToken = builder.clientToken;
        this.identifier = builder.identifier;
        this.patchDocument = builder.patchDocument;
    }

    public final String typeName() {
        return this.typeName;
    }

    public final String typeVersionId() {
        return this.typeVersionId;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String identifier() {
        return this.identifier;
    }

    public final String patchDocument() {
        return this.patchDocument;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.typeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.identifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.patchDocument());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateResourceRequest)) {
            return false;
        }
        UpdateResourceRequest other = (UpdateResourceRequest)((Object)obj);
        return Objects.equals(this.typeName(), other.typeName()) && Objects.equals(this.typeVersionId(), other.typeVersionId()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.identifier(), other.identifier()) && Objects.equals(this.patchDocument(), other.patchDocument());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateResourceRequest").add("TypeName", (Object)this.typeName()).add("TypeVersionId", (Object)this.typeVersionId()).add("RoleArn", (Object)this.roleArn()).add("ClientToken", (Object)this.clientToken()).add("Identifier", (Object)this.identifier()).add("PatchDocument", (Object)(this.patchDocument() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TypeName": {
                return Optional.ofNullable(clazz.cast(this.typeName()));
            }
            case "TypeVersionId": {
                return Optional.ofNullable(clazz.cast(this.typeVersionId()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "Identifier": {
                return Optional.ofNullable(clazz.cast(this.identifier()));
            }
            case "PatchDocument": {
                return Optional.ofNullable(clazz.cast(this.patchDocument()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("TypeName", TYPE_NAME_FIELD);
        map.put("TypeVersionId", TYPE_VERSION_ID_FIELD);
        map.put("RoleArn", ROLE_ARN_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("Identifier", IDENTIFIER_FIELD);
        map.put("PatchDocument", PATCH_DOCUMENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateResourceRequest, T> g) {
        return obj -> g.apply((UpdateResourceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudControlRequest.BuilderImpl
    implements Builder {
        private String typeName;
        private String typeVersionId;
        private String roleArn;
        private String clientToken;
        private String identifier;
        private String patchDocument;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateResourceRequest model) {
            super(model);
            this.typeName(model.typeName);
            this.typeVersionId(model.typeVersionId);
            this.roleArn(model.roleArn);
            this.clientToken(model.clientToken);
            this.identifier(model.identifier);
            this.patchDocument(model.patchDocument);
        }

        public final String getTypeName() {
            return this.typeName;
        }

        public final void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        @Override
        public final Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public final String getTypeVersionId() {
            return this.typeVersionId;
        }

        public final void setTypeVersionId(String typeVersionId) {
            this.typeVersionId = typeVersionId;
        }

        @Override
        public final Builder typeVersionId(String typeVersionId) {
            this.typeVersionId = typeVersionId;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getIdentifier() {
            return this.identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final String getPatchDocument() {
            return this.patchDocument;
        }

        public final void setPatchDocument(String patchDocument) {
            this.patchDocument = patchDocument;
        }

        @Override
        public final Builder patchDocument(String patchDocument) {
            this.patchDocument = patchDocument;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateResourceRequest build() {
            return new UpdateResourceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CloudControlRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateResourceRequest> {
        public Builder typeName(String var1);

        public Builder typeVersionId(String var1);

        public Builder roleArn(String var1);

        public Builder clientToken(String var1);

        public Builder identifier(String var1);

        public Builder patchDocument(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

