/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudcontrol.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudcontrol.model.CloudControlRequest;
import software.amazon.awssdk.services.cloudcontrol.model.ResourceRequestStatusFilter;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListResourceRequestsRequest
extends CloudControlRequest
implements ToCopyableBuilder<Builder, ListResourceRequestsRequest> {
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListResourceRequestsRequest.getter(ListResourceRequestsRequest::maxResults)).setter(ListResourceRequestsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListResourceRequestsRequest.getter(ListResourceRequestsRequest::nextToken)).setter(ListResourceRequestsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<ResourceRequestStatusFilter> RESOURCE_REQUEST_STATUS_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ResourceRequestStatusFilter").getter(ListResourceRequestsRequest.getter(ListResourceRequestsRequest::resourceRequestStatusFilter)).setter(ListResourceRequestsRequest.setter(Builder::resourceRequestStatusFilter)).constructor(ResourceRequestStatusFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceRequestStatusFilter").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, RESOURCE_REQUEST_STATUS_FILTER_FIELD));
    private final Integer maxResults;
    private final String nextToken;
    private final ResourceRequestStatusFilter resourceRequestStatusFilter;

    private ListResourceRequestsRequest(BuilderImpl builder) {
        super(builder);
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.resourceRequestStatusFilter = builder.resourceRequestStatusFilter;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final ResourceRequestStatusFilter resourceRequestStatusFilter() {
        return this.resourceRequestStatusFilter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceRequestStatusFilter());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListResourceRequestsRequest)) {
            return false;
        }
        ListResourceRequestsRequest other = (ListResourceRequestsRequest)((Object)obj);
        return Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.resourceRequestStatusFilter(), other.resourceRequestStatusFilter());
    }

    public final String toString() {
        return ToString.builder((String)"ListResourceRequestsRequest").add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("ResourceRequestStatusFilter", (Object)this.resourceRequestStatusFilter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "ResourceRequestStatusFilter": {
                return Optional.ofNullable(clazz.cast(this.resourceRequestStatusFilter()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListResourceRequestsRequest, T> g) {
        return obj -> g.apply((ListResourceRequestsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudControlRequest.BuilderImpl
    implements Builder {
        private Integer maxResults;
        private String nextToken;
        private ResourceRequestStatusFilter resourceRequestStatusFilter;

        private BuilderImpl() {
        }

        private BuilderImpl(ListResourceRequestsRequest model) {
            super(model);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.resourceRequestStatusFilter(model.resourceRequestStatusFilter);
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        @Transient
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final ResourceRequestStatusFilter.Builder getResourceRequestStatusFilter() {
            return this.resourceRequestStatusFilter != null ? this.resourceRequestStatusFilter.toBuilder() : null;
        }

        public final void setResourceRequestStatusFilter(ResourceRequestStatusFilter.BuilderImpl resourceRequestStatusFilter) {
            this.resourceRequestStatusFilter = resourceRequestStatusFilter != null ? resourceRequestStatusFilter.build() : null;
        }

        @Override
        @Transient
        public final Builder resourceRequestStatusFilter(ResourceRequestStatusFilter resourceRequestStatusFilter) {
            this.resourceRequestStatusFilter = resourceRequestStatusFilter;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListResourceRequestsRequest build() {
            return new ListResourceRequestsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudControlRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListResourceRequestsRequest> {
        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder resourceRequestStatusFilter(ResourceRequestStatusFilter var1);

        default public Builder resourceRequestStatusFilter(Consumer<ResourceRequestStatusFilter.Builder> resourceRequestStatusFilter) {
            return this.resourceRequestStatusFilter((ResourceRequestStatusFilter)((ResourceRequestStatusFilter.Builder)ResourceRequestStatusFilter.builder().applyMutation(resourceRequestStatusFilter)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

