/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloud9.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cloud9.model.EnvironmentMember;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class EnvironmentMemberMarshaller {
    private static final MarshallingInfo<String> PERMISSIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("permissions").isBinary(false).build();
    private static final MarshallingInfo<String> USERID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("userId").isBinary(false).build();
    private static final MarshallingInfo<String> USERARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("userArn").isBinary(false).build();
    private static final MarshallingInfo<String> ENVIRONMENTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("environmentId").isBinary(false).build();
    private static final MarshallingInfo<Instant> LASTACCESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastAccess").isBinary(false).build();
    private static final EnvironmentMemberMarshaller INSTANCE = new EnvironmentMemberMarshaller();

    private EnvironmentMemberMarshaller() {
    }

    public static EnvironmentMemberMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(EnvironmentMember environmentMember, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)environmentMember, (String)"environmentMember");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)environmentMember.permissionsString(), PERMISSIONS_BINDING);
            protocolMarshaller.marshall((Object)environmentMember.userId(), USERID_BINDING);
            protocolMarshaller.marshall((Object)environmentMember.userArn(), USERARN_BINDING);
            protocolMarshaller.marshall((Object)environmentMember.environmentId(), ENVIRONMENTID_BINDING);
            protocolMarshaller.marshall((Object)environmentMember.lastAccess(), LASTACCESS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

