/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloud9.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.cloud9.Cloud9Client;
import software.amazon.awssdk.services.cloud9.model.ListEnvironmentsRequest;
import software.amazon.awssdk.services.cloud9.model.ListEnvironmentsResponse;

public final class ListEnvironmentsPaginator
implements SdkIterable<ListEnvironmentsResponse> {
    private final Cloud9Client client;
    private final ListEnvironmentsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListEnvironmentsPaginator(Cloud9Client client, ListEnvironmentsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListEnvironmentsResponseFetcher();
    }

    public Iterator<ListEnvironmentsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    private class ListEnvironmentsResponseFetcher
    implements NextPageFetcher<ListEnvironmentsResponse> {
        private ListEnvironmentsResponseFetcher() {
        }

        public boolean hasNextPage(ListEnvironmentsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListEnvironmentsResponse nextPage(ListEnvironmentsResponse previousPage) {
            if (previousPage == null) {
                return ListEnvironmentsPaginator.this.client.listEnvironments(ListEnvironmentsPaginator.this.firstRequest);
            }
            return ListEnvironmentsPaginator.this.client.listEnvironments((ListEnvironmentsRequest)((Object)ListEnvironmentsPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

