/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloud9.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.cloud9.model.BoundedEnvironmentIdListCopier;
import software.amazon.awssdk.services.cloud9.model.Cloud9Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeEnvironmentsRequest
extends Cloud9Request
implements ToCopyableBuilder<Builder, DescribeEnvironmentsRequest> {
    private final List<String> environmentIds;

    private DescribeEnvironmentsRequest(BuilderImpl builder) {
        super(builder);
        this.environmentIds = builder.environmentIds;
    }

    public List<String> environmentIds() {
        return this.environmentIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentIds());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEnvironmentsRequest)) {
            return false;
        }
        DescribeEnvironmentsRequest other = (DescribeEnvironmentsRequest)((Object)obj);
        return Objects.equals(this.environmentIds(), other.environmentIds());
    }

    public String toString() {
        return ToString.builder((String)"DescribeEnvironmentsRequest").add("EnvironmentIds", this.environmentIds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "environmentIds": {
                return Optional.of(clazz.cast(this.environmentIds()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends Cloud9Request.BuilderImpl
    implements Builder {
        private List<String> environmentIds;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEnvironmentsRequest model) {
            this.environmentIds(model.environmentIds);
        }

        public final Collection<String> getEnvironmentIds() {
            return this.environmentIds;
        }

        @Override
        public final Builder environmentIds(Collection<String> environmentIds) {
            this.environmentIds = BoundedEnvironmentIdListCopier.copy(environmentIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environmentIds(String ... environmentIds) {
            this.environmentIds(Arrays.asList(environmentIds));
            return this;
        }

        public final void setEnvironmentIds(Collection<String> environmentIds) {
            this.environmentIds = BoundedEnvironmentIdListCopier.copy(environmentIds);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeEnvironmentsRequest build() {
            return new DescribeEnvironmentsRequest(this);
        }
    }

    public static interface Builder
    extends Cloud9Request.Builder,
    CopyableBuilder<Builder, DescribeEnvironmentsRequest> {
        public Builder environmentIds(Collection<String> var1);

        public Builder environmentIds(String ... var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

