/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloud9.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.cloud9.Cloud9Client;
import software.amazon.awssdk.services.cloud9.model.DescribeEnvironmentMembershipsRequest;
import software.amazon.awssdk.services.cloud9.model.DescribeEnvironmentMembershipsResponse;

public class DescribeEnvironmentMembershipsIterable
implements SdkIterable<DescribeEnvironmentMembershipsResponse> {
    private final Cloud9Client client;
    private final DescribeEnvironmentMembershipsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeEnvironmentMembershipsIterable(Cloud9Client client, DescribeEnvironmentMembershipsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeEnvironmentMembershipsResponseFetcher();
    }

    public Iterator<DescribeEnvironmentMembershipsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private final DescribeEnvironmentMembershipsIterable resume(DescribeEnvironmentMembershipsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeEnvironmentMembershipsIterable(this.client, (DescribeEnvironmentMembershipsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new DescribeEnvironmentMembershipsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<DescribeEnvironmentMembershipsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class DescribeEnvironmentMembershipsResponseFetcher
    implements SyncPageFetcher<DescribeEnvironmentMembershipsResponse> {
        private DescribeEnvironmentMembershipsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeEnvironmentMembershipsResponse previousPage) {
            return previousPage.nextToken() != null && !SdkAutoConstructList.class.isInstance(previousPage.nextToken()) && !SdkAutoConstructMap.class.isInstance(previousPage.nextToken());
        }

        public DescribeEnvironmentMembershipsResponse nextPage(DescribeEnvironmentMembershipsResponse previousPage) {
            if (previousPage == null) {
                return DescribeEnvironmentMembershipsIterable.this.client.describeEnvironmentMemberships(DescribeEnvironmentMembershipsIterable.this.firstRequest);
            }
            return DescribeEnvironmentMembershipsIterable.this.client.describeEnvironmentMemberships((DescribeEnvironmentMembershipsRequest)((Object)DescribeEnvironmentMembershipsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

