/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloud9.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.protocol.OperationInfo;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.ProtocolRequestMarshaller;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.services.cloud9.model.CreateEnvironmentEC2Request;
import software.amazon.awssdk.services.cloud9.transform.CreateEnvironmentEC2RequestModelMarshaller;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CreateEnvironmentEC2RequestMarshaller
implements Marshaller<Request<CreateEnvironmentEC2Request>, CreateEnvironmentEC2Request> {
    private static final OperationInfo SDK_OPERATION_BINDING = OperationInfo.builder().requestUri("/").httpMethodName(HttpMethodName.POST).hasExplicitPayloadMember(false).hasPayloadMembers(true).operationIdentifier("AWSCloud9WorkspaceManagementService.CreateEnvironmentEC2").serviceName("AWS Cloud9").build();
    private final AwsJsonProtocolFactory protocolFactory;

    public CreateEnvironmentEC2RequestMarshaller(AwsJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<CreateEnvironmentEC2Request> marshall(CreateEnvironmentEC2Request createEnvironmentEC2Request) {
        Validate.paramNotNull((Object)((Object)createEnvironmentEC2Request), (String)"createEnvironmentEC2Request");
        try {
            ProtocolRequestMarshaller protocolMarshaller = this.protocolFactory.createProtocolMarshaller(SDK_OPERATION_BINDING, (SdkRequest)createEnvironmentEC2Request);
            protocolMarshaller.startMarshalling();
            CreateEnvironmentEC2RequestModelMarshaller.getInstance().marshall(createEnvironmentEC2Request, (ProtocolMarshaller)protocolMarshaller);
            return protocolMarshaller.finishMarshalling();
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

