/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanroomsml.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides configuration information for the trained model inference job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TrainedModelInferenceJobsConfigurationPolicy implements SdkPojo, Serializable,
        ToCopyableBuilder<TrainedModelInferenceJobsConfigurationPolicy.Builder, TrainedModelInferenceJobsConfigurationPolicy> {
    private static final SdkField<List<LogsConfigurationPolicy>> CONTAINER_LOGS_FIELD = SdkField
            .<List<LogsConfigurationPolicy>> builder(MarshallingType.LIST)
            .memberName("containerLogs")
            .getter(getter(TrainedModelInferenceJobsConfigurationPolicy::containerLogs))
            .setter(setter(Builder::containerLogs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerLogs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LogsConfigurationPolicy> builder(MarshallingType.SDK_POJO)
                                            .constructor(LogsConfigurationPolicy::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<TrainedModelInferenceMaxOutputSize> MAX_OUTPUT_SIZE_FIELD = SdkField
            .<TrainedModelInferenceMaxOutputSize> builder(MarshallingType.SDK_POJO).memberName("maxOutputSize")
            .getter(getter(TrainedModelInferenceJobsConfigurationPolicy::maxOutputSize)).setter(setter(Builder::maxOutputSize))
            .constructor(TrainedModelInferenceMaxOutputSize::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxOutputSize").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTAINER_LOGS_FIELD,
            MAX_OUTPUT_SIZE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<LogsConfigurationPolicy> containerLogs;

    private final TrainedModelInferenceMaxOutputSize maxOutputSize;

    private TrainedModelInferenceJobsConfigurationPolicy(BuilderImpl builder) {
        this.containerLogs = builder.containerLogs;
        this.maxOutputSize = builder.maxOutputSize;
    }

    /**
     * For responses, this returns true if the service returned a value for the ContainerLogs property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasContainerLogs() {
        return containerLogs != null && !(containerLogs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The logs container for the trained model inference job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasContainerLogs} method.
     * </p>
     * 
     * @return The logs container for the trained model inference job.
     */
    public final List<LogsConfigurationPolicy> containerLogs() {
        return containerLogs;
    }

    /**
     * <p>
     * The maximum allowed size of the output of the trained model inference job.
     * </p>
     * 
     * @return The maximum allowed size of the output of the trained model inference job.
     */
    public final TrainedModelInferenceMaxOutputSize maxOutputSize() {
        return maxOutputSize;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasContainerLogs() ? containerLogs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxOutputSize());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrainedModelInferenceJobsConfigurationPolicy)) {
            return false;
        }
        TrainedModelInferenceJobsConfigurationPolicy other = (TrainedModelInferenceJobsConfigurationPolicy) obj;
        return hasContainerLogs() == other.hasContainerLogs() && Objects.equals(containerLogs(), other.containerLogs())
                && Objects.equals(maxOutputSize(), other.maxOutputSize());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TrainedModelInferenceJobsConfigurationPolicy")
                .add("ContainerLogs", hasContainerLogs() ? containerLogs() : null).add("MaxOutputSize", maxOutputSize()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "containerLogs":
            return Optional.ofNullable(clazz.cast(containerLogs()));
        case "maxOutputSize":
            return Optional.ofNullable(clazz.cast(maxOutputSize()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("containerLogs", CONTAINER_LOGS_FIELD);
        map.put("maxOutputSize", MAX_OUTPUT_SIZE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TrainedModelInferenceJobsConfigurationPolicy, T> g) {
        return obj -> g.apply((TrainedModelInferenceJobsConfigurationPolicy) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TrainedModelInferenceJobsConfigurationPolicy> {
        /**
         * <p>
         * The logs container for the trained model inference job.
         * </p>
         * 
         * @param containerLogs
         *        The logs container for the trained model inference job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerLogs(Collection<LogsConfigurationPolicy> containerLogs);

        /**
         * <p>
         * The logs container for the trained model inference job.
         * </p>
         * 
         * @param containerLogs
         *        The logs container for the trained model inference job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerLogs(LogsConfigurationPolicy... containerLogs);

        /**
         * <p>
         * The logs container for the trained model inference job.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cleanroomsml.model.LogsConfigurationPolicy.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.cleanroomsml.model.LogsConfigurationPolicy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cleanroomsml.model.LogsConfigurationPolicy.Builder#build()} is called
         * immediately and its result is passed to {@link #containerLogs(List<LogsConfigurationPolicy>)}.
         * 
         * @param containerLogs
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cleanroomsml.model.LogsConfigurationPolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #containerLogs(java.util.Collection<LogsConfigurationPolicy>)
         */
        Builder containerLogs(Consumer<LogsConfigurationPolicy.Builder>... containerLogs);

        /**
         * <p>
         * The maximum allowed size of the output of the trained model inference job.
         * </p>
         * 
         * @param maxOutputSize
         *        The maximum allowed size of the output of the trained model inference job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxOutputSize(TrainedModelInferenceMaxOutputSize maxOutputSize);

        /**
         * <p>
         * The maximum allowed size of the output of the trained model inference job.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link TrainedModelInferenceMaxOutputSize.Builder} avoiding the need to create one manually via
         * {@link TrainedModelInferenceMaxOutputSize#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TrainedModelInferenceMaxOutputSize.Builder#build()} is called
         * immediately and its result is passed to {@link #maxOutputSize(TrainedModelInferenceMaxOutputSize)}.
         * 
         * @param maxOutputSize
         *        a consumer that will call methods on {@link TrainedModelInferenceMaxOutputSize.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #maxOutputSize(TrainedModelInferenceMaxOutputSize)
         */
        default Builder maxOutputSize(Consumer<TrainedModelInferenceMaxOutputSize.Builder> maxOutputSize) {
            return maxOutputSize(TrainedModelInferenceMaxOutputSize.builder().applyMutation(maxOutputSize).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<LogsConfigurationPolicy> containerLogs = DefaultSdkAutoConstructList.getInstance();

        private TrainedModelInferenceMaxOutputSize maxOutputSize;

        private BuilderImpl() {
        }

        private BuilderImpl(TrainedModelInferenceJobsConfigurationPolicy model) {
            containerLogs(model.containerLogs);
            maxOutputSize(model.maxOutputSize);
        }

        public final List<LogsConfigurationPolicy.Builder> getContainerLogs() {
            List<LogsConfigurationPolicy.Builder> result = LogsConfigurationPolicyListCopier.copyToBuilder(this.containerLogs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContainerLogs(Collection<LogsConfigurationPolicy.BuilderImpl> containerLogs) {
            this.containerLogs = LogsConfigurationPolicyListCopier.copyFromBuilder(containerLogs);
        }

        @Override
        public final Builder containerLogs(Collection<LogsConfigurationPolicy> containerLogs) {
            this.containerLogs = LogsConfigurationPolicyListCopier.copy(containerLogs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containerLogs(LogsConfigurationPolicy... containerLogs) {
            containerLogs(Arrays.asList(containerLogs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containerLogs(Consumer<LogsConfigurationPolicy.Builder>... containerLogs) {
            containerLogs(Stream.of(containerLogs).map(c -> LogsConfigurationPolicy.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final TrainedModelInferenceMaxOutputSize.Builder getMaxOutputSize() {
            return maxOutputSize != null ? maxOutputSize.toBuilder() : null;
        }

        public final void setMaxOutputSize(TrainedModelInferenceMaxOutputSize.BuilderImpl maxOutputSize) {
            this.maxOutputSize = maxOutputSize != null ? maxOutputSize.build() : null;
        }

        @Override
        public final Builder maxOutputSize(TrainedModelInferenceMaxOutputSize maxOutputSize) {
            this.maxOutputSize = maxOutputSize;
            return this;
        }

        @Override
        public TrainedModelInferenceJobsConfigurationPolicy build() {
            return new TrainedModelInferenceJobsConfigurationPolicy(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
