/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanroomsml.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration settings for synthetic data generation, including the parameters that control data synthesis and the
 * evaluation scores that measure the quality and privacy characteristics of the generated synthetic data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SyntheticDataConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<SyntheticDataConfiguration.Builder, SyntheticDataConfiguration> {
    private static final SdkField<MLSyntheticDataParameters> SYNTHETIC_DATA_PARAMETERS_FIELD = SdkField
            .<MLSyntheticDataParameters> builder(MarshallingType.SDK_POJO).memberName("syntheticDataParameters")
            .getter(getter(SyntheticDataConfiguration::syntheticDataParameters)).setter(setter(Builder::syntheticDataParameters))
            .constructor(MLSyntheticDataParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("syntheticDataParameters").build())
            .build();

    private static final SdkField<SyntheticDataEvaluationScores> SYNTHETIC_DATA_EVALUATION_SCORES_FIELD = SdkField
            .<SyntheticDataEvaluationScores> builder(MarshallingType.SDK_POJO)
            .memberName("syntheticDataEvaluationScores")
            .getter(getter(SyntheticDataConfiguration::syntheticDataEvaluationScores))
            .setter(setter(Builder::syntheticDataEvaluationScores))
            .constructor(SyntheticDataEvaluationScores::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("syntheticDataEvaluationScores")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            SYNTHETIC_DATA_PARAMETERS_FIELD, SYNTHETIC_DATA_EVALUATION_SCORES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final MLSyntheticDataParameters syntheticDataParameters;

    private final SyntheticDataEvaluationScores syntheticDataEvaluationScores;

    private SyntheticDataConfiguration(BuilderImpl builder) {
        this.syntheticDataParameters = builder.syntheticDataParameters;
        this.syntheticDataEvaluationScores = builder.syntheticDataEvaluationScores;
    }

    /**
     * <p>
     * The parameters that control how synthetic data is generated, including privacy settings, column classifications,
     * and other configuration options that affect the data synthesis process.
     * </p>
     * 
     * @return The parameters that control how synthetic data is generated, including privacy settings, column
     *         classifications, and other configuration options that affect the data synthesis process.
     */
    public final MLSyntheticDataParameters syntheticDataParameters() {
        return syntheticDataParameters;
    }

    /**
     * <p>
     * Evaluation scores that assess the quality and privacy characteristics of the generated synthetic data, providing
     * metrics on data utility and privacy preservation.
     * </p>
     * 
     * @return Evaluation scores that assess the quality and privacy characteristics of the generated synthetic data,
     *         providing metrics on data utility and privacy preservation.
     */
    public final SyntheticDataEvaluationScores syntheticDataEvaluationScores() {
        return syntheticDataEvaluationScores;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(syntheticDataParameters());
        hashCode = 31 * hashCode + Objects.hashCode(syntheticDataEvaluationScores());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SyntheticDataConfiguration)) {
            return false;
        }
        SyntheticDataConfiguration other = (SyntheticDataConfiguration) obj;
        return Objects.equals(syntheticDataParameters(), other.syntheticDataParameters())
                && Objects.equals(syntheticDataEvaluationScores(), other.syntheticDataEvaluationScores());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SyntheticDataConfiguration").add("SyntheticDataParameters", syntheticDataParameters())
                .add("SyntheticDataEvaluationScores", syntheticDataEvaluationScores()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "syntheticDataParameters":
            return Optional.ofNullable(clazz.cast(syntheticDataParameters()));
        case "syntheticDataEvaluationScores":
            return Optional.ofNullable(clazz.cast(syntheticDataEvaluationScores()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("syntheticDataParameters", SYNTHETIC_DATA_PARAMETERS_FIELD);
        map.put("syntheticDataEvaluationScores", SYNTHETIC_DATA_EVALUATION_SCORES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SyntheticDataConfiguration, T> g) {
        return obj -> g.apply((SyntheticDataConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SyntheticDataConfiguration> {
        /**
         * <p>
         * The parameters that control how synthetic data is generated, including privacy settings, column
         * classifications, and other configuration options that affect the data synthesis process.
         * </p>
         * 
         * @param syntheticDataParameters
         *        The parameters that control how synthetic data is generated, including privacy settings, column
         *        classifications, and other configuration options that affect the data synthesis process.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder syntheticDataParameters(MLSyntheticDataParameters syntheticDataParameters);

        /**
         * <p>
         * The parameters that control how synthetic data is generated, including privacy settings, column
         * classifications, and other configuration options that affect the data synthesis process.
         * </p>
         * This is a convenience method that creates an instance of the {@link MLSyntheticDataParameters.Builder}
         * avoiding the need to create one manually via {@link MLSyntheticDataParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MLSyntheticDataParameters.Builder#build()} is called immediately
         * and its result is passed to {@link #syntheticDataParameters(MLSyntheticDataParameters)}.
         * 
         * @param syntheticDataParameters
         *        a consumer that will call methods on {@link MLSyntheticDataParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #syntheticDataParameters(MLSyntheticDataParameters)
         */
        default Builder syntheticDataParameters(Consumer<MLSyntheticDataParameters.Builder> syntheticDataParameters) {
            return syntheticDataParameters(MLSyntheticDataParameters.builder().applyMutation(syntheticDataParameters).build());
        }

        /**
         * <p>
         * Evaluation scores that assess the quality and privacy characteristics of the generated synthetic data,
         * providing metrics on data utility and privacy preservation.
         * </p>
         * 
         * @param syntheticDataEvaluationScores
         *        Evaluation scores that assess the quality and privacy characteristics of the generated synthetic data,
         *        providing metrics on data utility and privacy preservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder syntheticDataEvaluationScores(SyntheticDataEvaluationScores syntheticDataEvaluationScores);

        /**
         * <p>
         * Evaluation scores that assess the quality and privacy characteristics of the generated synthetic data,
         * providing metrics on data utility and privacy preservation.
         * </p>
         * This is a convenience method that creates an instance of the {@link SyntheticDataEvaluationScores.Builder}
         * avoiding the need to create one manually via {@link SyntheticDataEvaluationScores#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SyntheticDataEvaluationScores.Builder#build()} is called
         * immediately and its result is passed to {@link #syntheticDataEvaluationScores(SyntheticDataEvaluationScores)}.
         * 
         * @param syntheticDataEvaluationScores
         *        a consumer that will call methods on {@link SyntheticDataEvaluationScores.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #syntheticDataEvaluationScores(SyntheticDataEvaluationScores)
         */
        default Builder syntheticDataEvaluationScores(
                Consumer<SyntheticDataEvaluationScores.Builder> syntheticDataEvaluationScores) {
            return syntheticDataEvaluationScores(SyntheticDataEvaluationScores.builder()
                    .applyMutation(syntheticDataEvaluationScores).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private MLSyntheticDataParameters syntheticDataParameters;

        private SyntheticDataEvaluationScores syntheticDataEvaluationScores;

        private BuilderImpl() {
        }

        private BuilderImpl(SyntheticDataConfiguration model) {
            syntheticDataParameters(model.syntheticDataParameters);
            syntheticDataEvaluationScores(model.syntheticDataEvaluationScores);
        }

        public final MLSyntheticDataParameters.Builder getSyntheticDataParameters() {
            return syntheticDataParameters != null ? syntheticDataParameters.toBuilder() : null;
        }

        public final void setSyntheticDataParameters(MLSyntheticDataParameters.BuilderImpl syntheticDataParameters) {
            this.syntheticDataParameters = syntheticDataParameters != null ? syntheticDataParameters.build() : null;
        }

        @Override
        public final Builder syntheticDataParameters(MLSyntheticDataParameters syntheticDataParameters) {
            this.syntheticDataParameters = syntheticDataParameters;
            return this;
        }

        public final SyntheticDataEvaluationScores.Builder getSyntheticDataEvaluationScores() {
            return syntheticDataEvaluationScores != null ? syntheticDataEvaluationScores.toBuilder() : null;
        }

        public final void setSyntheticDataEvaluationScores(SyntheticDataEvaluationScores.BuilderImpl syntheticDataEvaluationScores) {
            this.syntheticDataEvaluationScores = syntheticDataEvaluationScores != null ? syntheticDataEvaluationScores.build()
                    : null;
        }

        @Override
        public final Builder syntheticDataEvaluationScores(SyntheticDataEvaluationScores syntheticDataEvaluationScores) {
            this.syntheticDataEvaluationScores = syntheticDataEvaluationScores;
            return this;
        }

        @Override
        public SyntheticDataConfiguration build() {
            return new SyntheticDataConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
