/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanroomsml.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTrainedModelInferenceJobsResponse extends CleanRoomsMlResponse implements
        ToCopyableBuilder<ListTrainedModelInferenceJobsResponse.Builder, ListTrainedModelInferenceJobsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListTrainedModelInferenceJobsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<TrainedModelInferenceJobSummary>> TRAINED_MODEL_INFERENCE_JOBS_FIELD = SdkField
            .<List<TrainedModelInferenceJobSummary>> builder(MarshallingType.LIST)
            .memberName("trainedModelInferenceJobs")
            .getter(getter(ListTrainedModelInferenceJobsResponse::trainedModelInferenceJobs))
            .setter(setter(Builder::trainedModelInferenceJobs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trainedModelInferenceJobs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TrainedModelInferenceJobSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(TrainedModelInferenceJobSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            TRAINED_MODEL_INFERENCE_JOBS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final List<TrainedModelInferenceJobSummary> trainedModelInferenceJobs;

    private ListTrainedModelInferenceJobsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.trainedModelInferenceJobs = builder.trainedModelInferenceJobs;
    }

    /**
     * <p>
     * The token value used to access the next page of results.
     * </p>
     * 
     * @return The token value used to access the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the TrainedModelInferenceJobs property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasTrainedModelInferenceJobs() {
        return trainedModelInferenceJobs != null && !(trainedModelInferenceJobs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Returns the requested trained model inference jobs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTrainedModelInferenceJobs} method.
     * </p>
     * 
     * @return Returns the requested trained model inference jobs.
     */
    public final List<TrainedModelInferenceJobSummary> trainedModelInferenceJobs() {
        return trainedModelInferenceJobs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasTrainedModelInferenceJobs() ? trainedModelInferenceJobs() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTrainedModelInferenceJobsResponse)) {
            return false;
        }
        ListTrainedModelInferenceJobsResponse other = (ListTrainedModelInferenceJobsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken())
                && hasTrainedModelInferenceJobs() == other.hasTrainedModelInferenceJobs()
                && Objects.equals(trainedModelInferenceJobs(), other.trainedModelInferenceJobs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListTrainedModelInferenceJobsResponse").add("NextToken", nextToken())
                .add("TrainedModelInferenceJobs", hasTrainedModelInferenceJobs() ? trainedModelInferenceJobs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "trainedModelInferenceJobs":
            return Optional.ofNullable(clazz.cast(trainedModelInferenceJobs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("trainedModelInferenceJobs", TRAINED_MODEL_INFERENCE_JOBS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListTrainedModelInferenceJobsResponse, T> g) {
        return obj -> g.apply((ListTrainedModelInferenceJobsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CleanRoomsMlResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListTrainedModelInferenceJobsResponse> {
        /**
         * <p>
         * The token value used to access the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The token value used to access the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Returns the requested trained model inference jobs.
         * </p>
         * 
         * @param trainedModelInferenceJobs
         *        Returns the requested trained model inference jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainedModelInferenceJobs(Collection<TrainedModelInferenceJobSummary> trainedModelInferenceJobs);

        /**
         * <p>
         * Returns the requested trained model inference jobs.
         * </p>
         * 
         * @param trainedModelInferenceJobs
         *        Returns the requested trained model inference jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainedModelInferenceJobs(TrainedModelInferenceJobSummary... trainedModelInferenceJobs);

        /**
         * <p>
         * Returns the requested trained model inference jobs.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cleanroomsml.model.TrainedModelInferenceJobSummary.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.cleanroomsml.model.TrainedModelInferenceJobSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cleanroomsml.model.TrainedModelInferenceJobSummary.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #trainedModelInferenceJobs(List<TrainedModelInferenceJobSummary>)}.
         * 
         * @param trainedModelInferenceJobs
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cleanroomsml.model.TrainedModelInferenceJobSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trainedModelInferenceJobs(java.util.Collection<TrainedModelInferenceJobSummary>)
         */
        Builder trainedModelInferenceJobs(Consumer<TrainedModelInferenceJobSummary.Builder>... trainedModelInferenceJobs);
    }

    static final class BuilderImpl extends CleanRoomsMlResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<TrainedModelInferenceJobSummary> trainedModelInferenceJobs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListTrainedModelInferenceJobsResponse model) {
            super(model);
            nextToken(model.nextToken);
            trainedModelInferenceJobs(model.trainedModelInferenceJobs);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<TrainedModelInferenceJobSummary.Builder> getTrainedModelInferenceJobs() {
            List<TrainedModelInferenceJobSummary.Builder> result = TrainedModelInferenceJobListCopier
                    .copyToBuilder(this.trainedModelInferenceJobs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTrainedModelInferenceJobs(
                Collection<TrainedModelInferenceJobSummary.BuilderImpl> trainedModelInferenceJobs) {
            this.trainedModelInferenceJobs = TrainedModelInferenceJobListCopier.copyFromBuilder(trainedModelInferenceJobs);
        }

        @Override
        public final Builder trainedModelInferenceJobs(Collection<TrainedModelInferenceJobSummary> trainedModelInferenceJobs) {
            this.trainedModelInferenceJobs = TrainedModelInferenceJobListCopier.copy(trainedModelInferenceJobs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trainedModelInferenceJobs(TrainedModelInferenceJobSummary... trainedModelInferenceJobs) {
            trainedModelInferenceJobs(Arrays.asList(trainedModelInferenceJobs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trainedModelInferenceJobs(
                Consumer<TrainedModelInferenceJobSummary.Builder>... trainedModelInferenceJobs) {
            trainedModelInferenceJobs(Stream.of(trainedModelInferenceJobs)
                    .map(c -> TrainedModelInferenceJobSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListTrainedModelInferenceJobsResponse build() {
            return new ListTrainedModelInferenceJobsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
