/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanroomsml.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about the data source that is used to create an ML input channel.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InputChannel implements SdkPojo, Serializable, ToCopyableBuilder<InputChannel.Builder, InputChannel> {
    private static final SdkField<InputChannelDataSource> DATA_SOURCE_FIELD = SdkField
            .<InputChannelDataSource> builder(MarshallingType.SDK_POJO).memberName("dataSource")
            .getter(getter(InputChannel::dataSource)).setter(setter(Builder::dataSource))
            .constructor(InputChannelDataSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSource").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(InputChannel::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SOURCE_FIELD,
            ROLE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final InputChannelDataSource dataSource;

    private final String roleArn;

    private InputChannel(BuilderImpl builder) {
        this.dataSource = builder.dataSource;
        this.roleArn = builder.roleArn;
    }

    /**
     * <p>
     * The data source that is used to create the ML input channel.
     * </p>
     * 
     * @return The data source that is used to create the ML input channel.
     */
    public final InputChannelDataSource dataSource() {
        return dataSource;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the role used to run the query specified in the <code>dataSource</code> field
     * of the input channel.
     * </p>
     * <p>
     * Passing a role across AWS accounts is not allowed. If you pass a role that isn't in your account, you get an
     * <code>AccessDeniedException</code> error.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the role used to run the query specified in the <code>dataSource</code>
     *         field of the input channel.</p>
     *         <p>
     *         Passing a role across AWS accounts is not allowed. If you pass a role that isn't in your account, you get
     *         an <code>AccessDeniedException</code> error.
     */
    public final String roleArn() {
        return roleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dataSource());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputChannel)) {
            return false;
        }
        InputChannel other = (InputChannel) obj;
        return Objects.equals(dataSource(), other.dataSource()) && Objects.equals(roleArn(), other.roleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InputChannel").add("DataSource", dataSource()).add("RoleArn", roleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "dataSource":
            return Optional.ofNullable(clazz.cast(dataSource()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("dataSource", DATA_SOURCE_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InputChannel, T> g) {
        return obj -> g.apply((InputChannel) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InputChannel> {
        /**
         * <p>
         * The data source that is used to create the ML input channel.
         * </p>
         * 
         * @param dataSource
         *        The data source that is used to create the ML input channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSource(InputChannelDataSource dataSource);

        /**
         * <p>
         * The data source that is used to create the ML input channel.
         * </p>
         * This is a convenience method that creates an instance of the {@link InputChannelDataSource.Builder} avoiding
         * the need to create one manually via {@link InputChannelDataSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InputChannelDataSource.Builder#build()} is called immediately and
         * its result is passed to {@link #dataSource(InputChannelDataSource)}.
         * 
         * @param dataSource
         *        a consumer that will call methods on {@link InputChannelDataSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataSource(InputChannelDataSource)
         */
        default Builder dataSource(Consumer<InputChannelDataSource.Builder> dataSource) {
            return dataSource(InputChannelDataSource.builder().applyMutation(dataSource).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the role used to run the query specified in the <code>dataSource</code>
         * field of the input channel.
         * </p>
         * <p>
         * Passing a role across AWS accounts is not allowed. If you pass a role that isn't in your account, you get an
         * <code>AccessDeniedException</code> error.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the role used to run the query specified in the
         *        <code>dataSource</code> field of the input channel.</p>
         *        <p>
         *        Passing a role across AWS accounts is not allowed. If you pass a role that isn't in your account, you
         *        get an <code>AccessDeniedException</code> error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);
    }

    static final class BuilderImpl implements Builder {
        private InputChannelDataSource dataSource;

        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(InputChannel model) {
            dataSource(model.dataSource);
            roleArn(model.roleArn);
        }

        public final InputChannelDataSource.Builder getDataSource() {
            return dataSource != null ? dataSource.toBuilder() : null;
        }

        public final void setDataSource(InputChannelDataSource.BuilderImpl dataSource) {
            this.dataSource = dataSource != null ? dataSource.build() : null;
        }

        @Override
        public final Builder dataSource(InputChannelDataSource dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        @Override
        public InputChannel build() {
            return new InputChannel(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
