/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanroomsml.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about an incremental training data channel that was used to create a trained model. This
 * structure provides details about the base model and channel configuration used during incremental training.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IncrementalTrainingDataChannelOutput implements SdkPojo, Serializable,
        ToCopyableBuilder<IncrementalTrainingDataChannelOutput.Builder, IncrementalTrainingDataChannelOutput> {
    private static final SdkField<String> CHANNEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("channelName").getter(getter(IncrementalTrainingDataChannelOutput::channelName))
            .setter(setter(Builder::channelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelName").build()).build();

    private static final SdkField<String> VERSION_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("versionIdentifier").getter(getter(IncrementalTrainingDataChannelOutput::versionIdentifier))
            .setter(setter(Builder::versionIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versionIdentifier").build()).build();

    private static final SdkField<String> MODEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("modelName").getter(getter(IncrementalTrainingDataChannelOutput::modelName))
            .setter(setter(Builder::modelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_NAME_FIELD,
            VERSION_IDENTIFIER_FIELD, MODEL_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String channelName;

    private final String versionIdentifier;

    private final String modelName;

    private IncrementalTrainingDataChannelOutput(BuilderImpl builder) {
        this.channelName = builder.channelName;
        this.versionIdentifier = builder.versionIdentifier;
        this.modelName = builder.modelName;
    }

    /**
     * <p>
     * The name of the incremental training data channel that was used.
     * </p>
     * 
     * @return The name of the incremental training data channel that was used.
     */
    public final String channelName() {
        return channelName;
    }

    /**
     * <p>
     * The version identifier of the trained model that was used for incremental training.
     * </p>
     * 
     * @return The version identifier of the trained model that was used for incremental training.
     */
    public final String versionIdentifier() {
        return versionIdentifier;
    }

    /**
     * <p>
     * The name of the base trained model that was used for incremental training.
     * </p>
     * 
     * @return The name of the base trained model that was used for incremental training.
     */
    public final String modelName() {
        return modelName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(channelName());
        hashCode = 31 * hashCode + Objects.hashCode(versionIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(modelName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IncrementalTrainingDataChannelOutput)) {
            return false;
        }
        IncrementalTrainingDataChannelOutput other = (IncrementalTrainingDataChannelOutput) obj;
        return Objects.equals(channelName(), other.channelName())
                && Objects.equals(versionIdentifier(), other.versionIdentifier())
                && Objects.equals(modelName(), other.modelName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IncrementalTrainingDataChannelOutput").add("ChannelName", channelName())
                .add("VersionIdentifier", versionIdentifier()).add("ModelName", modelName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "channelName":
            return Optional.ofNullable(clazz.cast(channelName()));
        case "versionIdentifier":
            return Optional.ofNullable(clazz.cast(versionIdentifier()));
        case "modelName":
            return Optional.ofNullable(clazz.cast(modelName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("channelName", CHANNEL_NAME_FIELD);
        map.put("versionIdentifier", VERSION_IDENTIFIER_FIELD);
        map.put("modelName", MODEL_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IncrementalTrainingDataChannelOutput, T> g) {
        return obj -> g.apply((IncrementalTrainingDataChannelOutput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IncrementalTrainingDataChannelOutput> {
        /**
         * <p>
         * The name of the incremental training data channel that was used.
         * </p>
         * 
         * @param channelName
         *        The name of the incremental training data channel that was used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelName(String channelName);

        /**
         * <p>
         * The version identifier of the trained model that was used for incremental training.
         * </p>
         * 
         * @param versionIdentifier
         *        The version identifier of the trained model that was used for incremental training.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionIdentifier(String versionIdentifier);

        /**
         * <p>
         * The name of the base trained model that was used for incremental training.
         * </p>
         * 
         * @param modelName
         *        The name of the base trained model that was used for incremental training.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelName(String modelName);
    }

    static final class BuilderImpl implements Builder {
        private String channelName;

        private String versionIdentifier;

        private String modelName;

        private BuilderImpl() {
        }

        private BuilderImpl(IncrementalTrainingDataChannelOutput model) {
            channelName(model.channelName);
            versionIdentifier(model.versionIdentifier);
            modelName(model.modelName);
        }

        public final String getChannelName() {
            return channelName;
        }

        public final void setChannelName(String channelName) {
            this.channelName = channelName;
        }

        @Override
        public final Builder channelName(String channelName) {
            this.channelName = channelName;
            return this;
        }

        public final String getVersionIdentifier() {
            return versionIdentifier;
        }

        public final void setVersionIdentifier(String versionIdentifier) {
            this.versionIdentifier = versionIdentifier;
        }

        @Override
        public final Builder versionIdentifier(String versionIdentifier) {
            this.versionIdentifier = versionIdentifier;
            return this;
        }

        public final String getModelName() {
            return modelName;
        }

        public final void setModelName(String modelName) {
            this.modelName = modelName;
        }

        @Override
        public final Builder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        @Override
        public IncrementalTrainingDataChannelOutput build() {
            return new IncrementalTrainingDataChannelOutput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
