/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanroomsml.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAudienceModelResponse extends CleanRoomsMlResponse implements
        ToCopyableBuilder<GetAudienceModelResponse.Builder, GetAudienceModelResponse> {
    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createTime")
            .getter(getter(GetAudienceModelResponse::createTime))
            .setter(setter(Builder::createTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updateTime")
            .getter(getter(GetAudienceModelResponse::updateTime))
            .setter(setter(Builder::updateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> TRAINING_DATA_START_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("trainingDataStartTime")
            .getter(getter(GetAudienceModelResponse::trainingDataStartTime))
            .setter(setter(Builder::trainingDataStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trainingDataStartTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> TRAINING_DATA_END_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("trainingDataEndTime")
            .getter(getter(GetAudienceModelResponse::trainingDataEndTime))
            .setter(setter(Builder::trainingDataEndTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trainingDataEndTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> AUDIENCE_MODEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("audienceModelArn").getter(getter(GetAudienceModelResponse::audienceModelArn))
            .setter(setter(Builder::audienceModelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audienceModelArn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(GetAudienceModelResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> TRAINING_DATASET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("trainingDatasetArn").getter(getter(GetAudienceModelResponse::trainingDatasetArn))
            .setter(setter(Builder::trainingDatasetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trainingDatasetArn").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetAudienceModelResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<StatusDetails> STATUS_DETAILS_FIELD = SdkField
            .<StatusDetails> builder(MarshallingType.SDK_POJO).memberName("statusDetails")
            .getter(getter(GetAudienceModelResponse::statusDetails)).setter(setter(Builder::statusDetails))
            .constructor(StatusDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusDetails").build()).build();

    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("kmsKeyArn").getter(getter(GetAudienceModelResponse::kmsKeyArn)).setter(setter(Builder::kmsKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyArn").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(GetAudienceModelResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(GetAudienceModelResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATE_TIME_FIELD,
            UPDATE_TIME_FIELD, TRAINING_DATA_START_TIME_FIELD, TRAINING_DATA_END_TIME_FIELD, AUDIENCE_MODEL_ARN_FIELD,
            NAME_FIELD, TRAINING_DATASET_ARN_FIELD, STATUS_FIELD, STATUS_DETAILS_FIELD, KMS_KEY_ARN_FIELD, TAGS_FIELD,
            DESCRIPTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Instant createTime;

    private final Instant updateTime;

    private final Instant trainingDataStartTime;

    private final Instant trainingDataEndTime;

    private final String audienceModelArn;

    private final String name;

    private final String trainingDatasetArn;

    private final String status;

    private final StatusDetails statusDetails;

    private final String kmsKeyArn;

    private final Map<String, String> tags;

    private final String description;

    private GetAudienceModelResponse(BuilderImpl builder) {
        super(builder);
        this.createTime = builder.createTime;
        this.updateTime = builder.updateTime;
        this.trainingDataStartTime = builder.trainingDataStartTime;
        this.trainingDataEndTime = builder.trainingDataEndTime;
        this.audienceModelArn = builder.audienceModelArn;
        this.name = builder.name;
        this.trainingDatasetArn = builder.trainingDatasetArn;
        this.status = builder.status;
        this.statusDetails = builder.statusDetails;
        this.kmsKeyArn = builder.kmsKeyArn;
        this.tags = builder.tags;
        this.description = builder.description;
    }

    /**
     * <p>
     * The time at which the audience model was created.
     * </p>
     * 
     * @return The time at which the audience model was created.
     */
    public final Instant createTime() {
        return createTime;
    }

    /**
     * <p>
     * The most recent time at which the audience model was updated.
     * </p>
     * 
     * @return The most recent time at which the audience model was updated.
     */
    public final Instant updateTime() {
        return updateTime;
    }

    /**
     * <p>
     * The start date specified for the training window.
     * </p>
     * 
     * @return The start date specified for the training window.
     */
    public final Instant trainingDataStartTime() {
        return trainingDataStartTime;
    }

    /**
     * <p>
     * The end date specified for the training window.
     * </p>
     * 
     * @return The end date specified for the training window.
     */
    public final Instant trainingDataEndTime() {
        return trainingDataEndTime;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the audience model.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the audience model.
     */
    public final String audienceModelArn() {
        return audienceModelArn;
    }

    /**
     * <p>
     * The name of the audience model.
     * </p>
     * 
     * @return The name of the audience model.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the training dataset that was used for this audience model.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the training dataset that was used for this audience model.
     */
    public final String trainingDatasetArn() {
        return trainingDatasetArn;
    }

    /**
     * <p>
     * The status of the audience model.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AudienceModelStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the audience model.
     * @see AudienceModelStatus
     */
    public final AudienceModelStatus status() {
        return AudienceModelStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the audience model.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AudienceModelStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the audience model.
     * @see AudienceModelStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Details about the status of the audience model.
     * </p>
     * 
     * @return Details about the status of the audience model.
     */
    public final StatusDetails statusDetails() {
        return statusDetails;
    }

    /**
     * <p>
     * The KMS key ARN used for the audience model.
     * </p>
     * 
     * @return The KMS key ARN used for the audience model.
     */
    public final String kmsKeyArn() {
        return kmsKeyArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags that are assigned to the audience model.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags that are assigned to the audience model.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The description of the audience model.
     * </p>
     * 
     * @return The description of the audience model.
     */
    public final String description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(createTime());
        hashCode = 31 * hashCode + Objects.hashCode(updateTime());
        hashCode = 31 * hashCode + Objects.hashCode(trainingDataStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(trainingDataEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(audienceModelArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(trainingDatasetArn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusDetails());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(description());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAudienceModelResponse)) {
            return false;
        }
        GetAudienceModelResponse other = (GetAudienceModelResponse) obj;
        return Objects.equals(createTime(), other.createTime()) && Objects.equals(updateTime(), other.updateTime())
                && Objects.equals(trainingDataStartTime(), other.trainingDataStartTime())
                && Objects.equals(trainingDataEndTime(), other.trainingDataEndTime())
                && Objects.equals(audienceModelArn(), other.audienceModelArn()) && Objects.equals(name(), other.name())
                && Objects.equals(trainingDatasetArn(), other.trainingDatasetArn())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusDetails(), other.statusDetails()) && Objects.equals(kmsKeyArn(), other.kmsKeyArn())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(description(), other.description());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetAudienceModelResponse").add("CreateTime", createTime()).add("UpdateTime", updateTime())
                .add("TrainingDataStartTime", trainingDataStartTime()).add("TrainingDataEndTime", trainingDataEndTime())
                .add("AudienceModelArn", audienceModelArn()).add("Name", name()).add("TrainingDatasetArn", trainingDatasetArn())
                .add("Status", statusAsString()).add("StatusDetails", statusDetails()).add("KmsKeyArn", kmsKeyArn())
                .add("Tags", hasTags() ? tags() : null).add("Description", description()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "createTime":
            return Optional.ofNullable(clazz.cast(createTime()));
        case "updateTime":
            return Optional.ofNullable(clazz.cast(updateTime()));
        case "trainingDataStartTime":
            return Optional.ofNullable(clazz.cast(trainingDataStartTime()));
        case "trainingDataEndTime":
            return Optional.ofNullable(clazz.cast(trainingDataEndTime()));
        case "audienceModelArn":
            return Optional.ofNullable(clazz.cast(audienceModelArn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "trainingDatasetArn":
            return Optional.ofNullable(clazz.cast(trainingDatasetArn()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "statusDetails":
            return Optional.ofNullable(clazz.cast(statusDetails()));
        case "kmsKeyArn":
            return Optional.ofNullable(clazz.cast(kmsKeyArn()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("createTime", CREATE_TIME_FIELD);
        map.put("updateTime", UPDATE_TIME_FIELD);
        map.put("trainingDataStartTime", TRAINING_DATA_START_TIME_FIELD);
        map.put("trainingDataEndTime", TRAINING_DATA_END_TIME_FIELD);
        map.put("audienceModelArn", AUDIENCE_MODEL_ARN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("trainingDatasetArn", TRAINING_DATASET_ARN_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("statusDetails", STATUS_DETAILS_FIELD);
        map.put("kmsKeyArn", KMS_KEY_ARN_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetAudienceModelResponse, T> g) {
        return obj -> g.apply((GetAudienceModelResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CleanRoomsMlResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetAudienceModelResponse> {
        /**
         * <p>
         * The time at which the audience model was created.
         * </p>
         * 
         * @param createTime
         *        The time at which the audience model was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTime(Instant createTime);

        /**
         * <p>
         * The most recent time at which the audience model was updated.
         * </p>
         * 
         * @param updateTime
         *        The most recent time at which the audience model was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateTime(Instant updateTime);

        /**
         * <p>
         * The start date specified for the training window.
         * </p>
         * 
         * @param trainingDataStartTime
         *        The start date specified for the training window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainingDataStartTime(Instant trainingDataStartTime);

        /**
         * <p>
         * The end date specified for the training window.
         * </p>
         * 
         * @param trainingDataEndTime
         *        The end date specified for the training window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainingDataEndTime(Instant trainingDataEndTime);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the audience model.
         * </p>
         * 
         * @param audienceModelArn
         *        The Amazon Resource Name (ARN) of the audience model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder audienceModelArn(String audienceModelArn);

        /**
         * <p>
         * The name of the audience model.
         * </p>
         * 
         * @param name
         *        The name of the audience model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the training dataset that was used for this audience model.
         * </p>
         * 
         * @param trainingDatasetArn
         *        The Amazon Resource Name (ARN) of the training dataset that was used for this audience model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainingDatasetArn(String trainingDatasetArn);

        /**
         * <p>
         * The status of the audience model.
         * </p>
         * 
         * @param status
         *        The status of the audience model.
         * @see AudienceModelStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AudienceModelStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the audience model.
         * </p>
         * 
         * @param status
         *        The status of the audience model.
         * @see AudienceModelStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AudienceModelStatus
         */
        Builder status(AudienceModelStatus status);

        /**
         * <p>
         * Details about the status of the audience model.
         * </p>
         * 
         * @param statusDetails
         *        Details about the status of the audience model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusDetails(StatusDetails statusDetails);

        /**
         * <p>
         * Details about the status of the audience model.
         * </p>
         * This is a convenience method that creates an instance of the {@link StatusDetails.Builder} avoiding the need
         * to create one manually via {@link StatusDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StatusDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #statusDetails(StatusDetails)}.
         * 
         * @param statusDetails
         *        a consumer that will call methods on {@link StatusDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #statusDetails(StatusDetails)
         */
        default Builder statusDetails(Consumer<StatusDetails.Builder> statusDetails) {
            return statusDetails(StatusDetails.builder().applyMutation(statusDetails).build());
        }

        /**
         * <p>
         * The KMS key ARN used for the audience model.
         * </p>
         * 
         * @param kmsKeyArn
         *        The KMS key ARN used for the audience model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyArn(String kmsKeyArn);

        /**
         * <p>
         * The tags that are assigned to the audience model.
         * </p>
         * 
         * @param tags
         *        The tags that are assigned to the audience model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The description of the audience model.
         * </p>
         * 
         * @param description
         *        The description of the audience model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);
    }

    static final class BuilderImpl extends CleanRoomsMlResponse.BuilderImpl implements Builder {
        private Instant createTime;

        private Instant updateTime;

        private Instant trainingDataStartTime;

        private Instant trainingDataEndTime;

        private String audienceModelArn;

        private String name;

        private String trainingDatasetArn;

        private String status;

        private StatusDetails statusDetails;

        private String kmsKeyArn;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAudienceModelResponse model) {
            super(model);
            createTime(model.createTime);
            updateTime(model.updateTime);
            trainingDataStartTime(model.trainingDataStartTime);
            trainingDataEndTime(model.trainingDataEndTime);
            audienceModelArn(model.audienceModelArn);
            name(model.name);
            trainingDatasetArn(model.trainingDatasetArn);
            status(model.status);
            statusDetails(model.statusDetails);
            kmsKeyArn(model.kmsKeyArn);
            tags(model.tags);
            description(model.description);
        }

        public final Instant getCreateTime() {
            return createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Instant getUpdateTime() {
            return updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public final Instant getTrainingDataStartTime() {
            return trainingDataStartTime;
        }

        public final void setTrainingDataStartTime(Instant trainingDataStartTime) {
            this.trainingDataStartTime = trainingDataStartTime;
        }

        @Override
        public final Builder trainingDataStartTime(Instant trainingDataStartTime) {
            this.trainingDataStartTime = trainingDataStartTime;
            return this;
        }

        public final Instant getTrainingDataEndTime() {
            return trainingDataEndTime;
        }

        public final void setTrainingDataEndTime(Instant trainingDataEndTime) {
            this.trainingDataEndTime = trainingDataEndTime;
        }

        @Override
        public final Builder trainingDataEndTime(Instant trainingDataEndTime) {
            this.trainingDataEndTime = trainingDataEndTime;
            return this;
        }

        public final String getAudienceModelArn() {
            return audienceModelArn;
        }

        public final void setAudienceModelArn(String audienceModelArn) {
            this.audienceModelArn = audienceModelArn;
        }

        @Override
        public final Builder audienceModelArn(String audienceModelArn) {
            this.audienceModelArn = audienceModelArn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getTrainingDatasetArn() {
            return trainingDatasetArn;
        }

        public final void setTrainingDatasetArn(String trainingDatasetArn) {
            this.trainingDatasetArn = trainingDatasetArn;
        }

        @Override
        public final Builder trainingDatasetArn(String trainingDatasetArn) {
            this.trainingDatasetArn = trainingDatasetArn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AudienceModelStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final StatusDetails.Builder getStatusDetails() {
            return statusDetails != null ? statusDetails.toBuilder() : null;
        }

        public final void setStatusDetails(StatusDetails.BuilderImpl statusDetails) {
            this.statusDetails = statusDetails != null ? statusDetails.build() : null;
        }

        @Override
        public final Builder statusDetails(StatusDetails statusDetails) {
            this.statusDetails = statusDetails;
            return this;
        }

        public final String getKmsKeyArn() {
            return kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public GetAudienceModelResponse build() {
            return new GetAudienceModelResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
