/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanroomsml.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class DatasetInputConfigSchemaListCopier {
    static List<ColumnSchema> copy(Collection<? extends ColumnSchema> datasetInputConfigSchemaListParam) {
        List<ColumnSchema> list;
        if (datasetInputConfigSchemaListParam == null || datasetInputConfigSchemaListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<ColumnSchema> modifiableList = new ArrayList<>(datasetInputConfigSchemaListParam.size());
            datasetInputConfigSchemaListParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<ColumnSchema> copyFromBuilder(Collection<? extends ColumnSchema.Builder> datasetInputConfigSchemaListParam) {
        List<ColumnSchema> list;
        if (datasetInputConfigSchemaListParam == null || datasetInputConfigSchemaListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<ColumnSchema> modifiableList = new ArrayList<>(datasetInputConfigSchemaListParam.size());
            datasetInputConfigSchemaListParam.forEach(entry -> {
                ColumnSchema member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<ColumnSchema.Builder> copyToBuilder(Collection<? extends ColumnSchema> datasetInputConfigSchemaListParam) {
        List<ColumnSchema.Builder> list;
        if (datasetInputConfigSchemaListParam == null || datasetInputConfigSchemaListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<ColumnSchema.Builder> modifiableList = new ArrayList<>(datasetInputConfigSchemaListParam.size());
            datasetInputConfigSchemaListParam.forEach(entry -> {
                ColumnSchema.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
