/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanroomsml.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cleanroomsml.model.ContainerArgumentsCopier;
import software.amazon.awssdk.services.cleanroomsml.model.ContainerEntrypointCopier;
import software.amazon.awssdk.services.cleanroomsml.model.MetricDefinition;
import software.amazon.awssdk.services.cleanroomsml.model.MetricDefinitionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ContainerConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ContainerConfig> {
    private static final SdkField<String> IMAGE_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("imageUri").getter(ContainerConfig.getter(ContainerConfig::imageUri)).setter(ContainerConfig.setter(Builder::imageUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageUri").build()}).build();
    private static final SdkField<List<String>> ENTRYPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("entrypoint").getter(ContainerConfig.getter(ContainerConfig::entrypoint)).setter(ContainerConfig.setter(Builder::entrypoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entrypoint").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ARGUMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("arguments").getter(ContainerConfig.getter(ContainerConfig::arguments)).setter(ContainerConfig.setter(Builder::arguments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arguments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<MetricDefinition>> METRIC_DEFINITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("metricDefinitions").getter(ContainerConfig.getter(ContainerConfig::metricDefinitions)).setter(ContainerConfig.setter(Builder::metricDefinitions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricDefinitions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MetricDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_URI_FIELD, ENTRYPOINT_FIELD, ARGUMENTS_FIELD, METRIC_DEFINITIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ContainerConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String imageUri;
    private final List<String> entrypoint;
    private final List<String> arguments;
    private final List<MetricDefinition> metricDefinitions;

    private ContainerConfig(BuilderImpl builder) {
        this.imageUri = builder.imageUri;
        this.entrypoint = builder.entrypoint;
        this.arguments = builder.arguments;
        this.metricDefinitions = builder.metricDefinitions;
    }

    public final String imageUri() {
        return this.imageUri;
    }

    public final boolean hasEntrypoint() {
        return this.entrypoint != null && !(this.entrypoint instanceof SdkAutoConstructList);
    }

    public final List<String> entrypoint() {
        return this.entrypoint;
    }

    public final boolean hasArguments() {
        return this.arguments != null && !(this.arguments instanceof SdkAutoConstructList);
    }

    public final List<String> arguments() {
        return this.arguments;
    }

    public final boolean hasMetricDefinitions() {
        return this.metricDefinitions != null && !(this.metricDefinitions instanceof SdkAutoConstructList);
    }

    public final List<MetricDefinition> metricDefinitions() {
        return this.metricDefinitions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.imageUri());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEntrypoint() ? this.entrypoint() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasArguments() ? this.arguments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetricDefinitions() ? this.metricDefinitions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContainerConfig)) {
            return false;
        }
        ContainerConfig other = (ContainerConfig)obj;
        return Objects.equals(this.imageUri(), other.imageUri()) && this.hasEntrypoint() == other.hasEntrypoint() && Objects.equals(this.entrypoint(), other.entrypoint()) && this.hasArguments() == other.hasArguments() && Objects.equals(this.arguments(), other.arguments()) && this.hasMetricDefinitions() == other.hasMetricDefinitions() && Objects.equals(this.metricDefinitions(), other.metricDefinitions());
    }

    public final String toString() {
        return ToString.builder((String)"ContainerConfig").add("ImageUri", (Object)this.imageUri()).add("Entrypoint", this.hasEntrypoint() ? this.entrypoint() : null).add("Arguments", this.hasArguments() ? this.arguments() : null).add("MetricDefinitions", this.hasMetricDefinitions() ? this.metricDefinitions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "imageUri": {
                return Optional.ofNullable(clazz.cast(this.imageUri()));
            }
            case "entrypoint": {
                return Optional.ofNullable(clazz.cast(this.entrypoint()));
            }
            case "arguments": {
                return Optional.ofNullable(clazz.cast(this.arguments()));
            }
            case "metricDefinitions": {
                return Optional.ofNullable(clazz.cast(this.metricDefinitions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("imageUri", IMAGE_URI_FIELD);
        map.put("entrypoint", ENTRYPOINT_FIELD);
        map.put("arguments", ARGUMENTS_FIELD);
        map.put("metricDefinitions", METRIC_DEFINITIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ContainerConfig, T> g) {
        return obj -> g.apply((ContainerConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String imageUri;
        private List<String> entrypoint = DefaultSdkAutoConstructList.getInstance();
        private List<String> arguments = DefaultSdkAutoConstructList.getInstance();
        private List<MetricDefinition> metricDefinitions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ContainerConfig model) {
            this.imageUri(model.imageUri);
            this.entrypoint(model.entrypoint);
            this.arguments(model.arguments);
            this.metricDefinitions(model.metricDefinitions);
        }

        public final String getImageUri() {
            return this.imageUri;
        }

        public final void setImageUri(String imageUri) {
            this.imageUri = imageUri;
        }

        @Override
        public final Builder imageUri(String imageUri) {
            this.imageUri = imageUri;
            return this;
        }

        public final Collection<String> getEntrypoint() {
            if (this.entrypoint instanceof SdkAutoConstructList) {
                return null;
            }
            return this.entrypoint;
        }

        public final void setEntrypoint(Collection<String> entrypoint) {
            this.entrypoint = ContainerEntrypointCopier.copy(entrypoint);
        }

        @Override
        public final Builder entrypoint(Collection<String> entrypoint) {
            this.entrypoint = ContainerEntrypointCopier.copy(entrypoint);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entrypoint(String ... entrypoint) {
            this.entrypoint(Arrays.asList(entrypoint));
            return this;
        }

        public final Collection<String> getArguments() {
            if (this.arguments instanceof SdkAutoConstructList) {
                return null;
            }
            return this.arguments;
        }

        public final void setArguments(Collection<String> arguments) {
            this.arguments = ContainerArgumentsCopier.copy(arguments);
        }

        @Override
        public final Builder arguments(Collection<String> arguments) {
            this.arguments = ContainerArgumentsCopier.copy(arguments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder arguments(String ... arguments) {
            this.arguments(Arrays.asList(arguments));
            return this;
        }

        public final List<MetricDefinition.Builder> getMetricDefinitions() {
            List<MetricDefinition.Builder> result = MetricDefinitionListCopier.copyToBuilder(this.metricDefinitions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetricDefinitions(Collection<MetricDefinition.BuilderImpl> metricDefinitions) {
            this.metricDefinitions = MetricDefinitionListCopier.copyFromBuilder(metricDefinitions);
        }

        @Override
        public final Builder metricDefinitions(Collection<MetricDefinition> metricDefinitions) {
            this.metricDefinitions = MetricDefinitionListCopier.copy(metricDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricDefinitions(MetricDefinition ... metricDefinitions) {
            this.metricDefinitions(Arrays.asList(metricDefinitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricDefinitions(Consumer<MetricDefinition.Builder> ... metricDefinitions) {
            this.metricDefinitions(Stream.of(metricDefinitions).map(c -> (MetricDefinition)((MetricDefinition.Builder)MetricDefinition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ContainerConfig build() {
            return new ContainerConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ContainerConfig> {
        public Builder imageUri(String var1);

        public Builder entrypoint(Collection<String> var1);

        public Builder entrypoint(String ... var1);

        public Builder arguments(Collection<String> var1);

        public Builder arguments(String ... var1);

        public Builder metricDefinitions(Collection<MetricDefinition> var1);

        public Builder metricDefinitions(MetricDefinition ... var1);

        public Builder metricDefinitions(Consumer<MetricDefinition.Builder> ... var1);
    }
}

