/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanroomsml.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.cleanroomsml.model.ParameterMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProtectedQuerySQLParameters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProtectedQuerySQLParameters> {
    private static final SdkField<String> QUERY_STRING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("queryString").getter(ProtectedQuerySQLParameters.getter(ProtectedQuerySQLParameters::queryString)).setter(ProtectedQuerySQLParameters.setter(Builder::queryString)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryString").build()}).build();
    private static final SdkField<String> ANALYSIS_TEMPLATE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("analysisTemplateArn").getter(ProtectedQuerySQLParameters.getter(ProtectedQuerySQLParameters::analysisTemplateArn)).setter(ProtectedQuerySQLParameters.setter(Builder::analysisTemplateArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("analysisTemplateArn").build()}).build();
    private static final SdkField<Map<String, String>> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("parameters").getter(ProtectedQuerySQLParameters.getter(ProtectedQuerySQLParameters::parameters)).setter(ProtectedQuerySQLParameters.setter(Builder::parameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUERY_STRING_FIELD, ANALYSIS_TEMPLATE_ARN_FIELD, PARAMETERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ProtectedQuerySQLParameters.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String queryString;
    private final String analysisTemplateArn;
    private final Map<String, String> parameters;

    private ProtectedQuerySQLParameters(BuilderImpl builder) {
        this.queryString = builder.queryString;
        this.analysisTemplateArn = builder.analysisTemplateArn;
        this.parameters = builder.parameters;
    }

    public final String queryString() {
        return this.queryString;
    }

    public final String analysisTemplateArn() {
        return this.analysisTemplateArn;
    }

    public final boolean hasParameters() {
        return this.parameters != null && !(this.parameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> parameters() {
        return this.parameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.queryString());
        hashCode = 31 * hashCode + Objects.hashCode(this.analysisTemplateArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParameters() ? this.parameters() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProtectedQuerySQLParameters)) {
            return false;
        }
        ProtectedQuerySQLParameters other = (ProtectedQuerySQLParameters)obj;
        return Objects.equals(this.queryString(), other.queryString()) && Objects.equals(this.analysisTemplateArn(), other.analysisTemplateArn()) && this.hasParameters() == other.hasParameters() && Objects.equals(this.parameters(), other.parameters());
    }

    public final String toString() {
        return ToString.builder((String)"ProtectedQuerySQLParameters").add("QueryString", (Object)this.queryString()).add("AnalysisTemplateArn", (Object)this.analysisTemplateArn()).add("Parameters", this.hasParameters() ? this.parameters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "queryString": {
                return Optional.ofNullable(clazz.cast(this.queryString()));
            }
            case "analysisTemplateArn": {
                return Optional.ofNullable(clazz.cast(this.analysisTemplateArn()));
            }
            case "parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("queryString", QUERY_STRING_FIELD);
        map.put("analysisTemplateArn", ANALYSIS_TEMPLATE_ARN_FIELD);
        map.put("parameters", PARAMETERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProtectedQuerySQLParameters, T> g) {
        return obj -> g.apply((ProtectedQuerySQLParameters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String queryString;
        private String analysisTemplateArn;
        private Map<String, String> parameters = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ProtectedQuerySQLParameters model) {
            this.queryString(model.queryString);
            this.analysisTemplateArn(model.analysisTemplateArn);
            this.parameters(model.parameters);
        }

        public final String getQueryString() {
            return this.queryString;
        }

        public final void setQueryString(String queryString) {
            this.queryString = queryString;
        }

        @Override
        public final Builder queryString(String queryString) {
            this.queryString = queryString;
            return this;
        }

        public final String getAnalysisTemplateArn() {
            return this.analysisTemplateArn;
        }

        public final void setAnalysisTemplateArn(String analysisTemplateArn) {
            this.analysisTemplateArn = analysisTemplateArn;
        }

        @Override
        public final Builder analysisTemplateArn(String analysisTemplateArn) {
            this.analysisTemplateArn = analysisTemplateArn;
            return this;
        }

        public final Map<String, String> getParameters() {
            if (this.parameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.parameters;
        }

        public final void setParameters(Map<String, String> parameters) {
            this.parameters = ParameterMapCopier.copy(parameters);
        }

        @Override
        public final Builder parameters(Map<String, String> parameters) {
            this.parameters = ParameterMapCopier.copy(parameters);
            return this;
        }

        public ProtectedQuerySQLParameters build() {
            return new ProtectedQuerySQLParameters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProtectedQuerySQLParameters> {
        public Builder queryString(String var1);

        public Builder analysisTemplateArn(String var1);

        public Builder parameters(Map<String, String> var1);
    }
}

