/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanroomsml.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cleanroomsml.model.AudienceExportJobStatus;
import software.amazon.awssdk.services.cleanroomsml.model.AudienceSize;
import software.amazon.awssdk.services.cleanroomsml.model.StatusDetails;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AudienceExportJobSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AudienceExportJobSummary> {
    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createTime").getter(AudienceExportJobSummary.getter(AudienceExportJobSummary::createTime)).setter(AudienceExportJobSummary.setter(Builder::createTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updateTime").getter(AudienceExportJobSummary.getter(AudienceExportJobSummary::updateTime)).setter(AudienceExportJobSummary.setter(Builder::updateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(AudienceExportJobSummary.getter(AudienceExportJobSummary::name)).setter(AudienceExportJobSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> AUDIENCE_GENERATION_JOB_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("audienceGenerationJobArn").getter(AudienceExportJobSummary.getter(AudienceExportJobSummary::audienceGenerationJobArn)).setter(AudienceExportJobSummary.setter(Builder::audienceGenerationJobArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audienceGenerationJobArn").build()}).build();
    private static final SdkField<AudienceSize> AUDIENCE_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("audienceSize").getter(AudienceExportJobSummary.getter(AudienceExportJobSummary::audienceSize)).setter(AudienceExportJobSummary.setter(Builder::audienceSize)).constructor(AudienceSize::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audienceSize").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(AudienceExportJobSummary.getter(AudienceExportJobSummary::description)).setter(AudienceExportJobSummary.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(AudienceExportJobSummary.getter(AudienceExportJobSummary::statusAsString)).setter(AudienceExportJobSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<StatusDetails> STATUS_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("statusDetails").getter(AudienceExportJobSummary.getter(AudienceExportJobSummary::statusDetails)).setter(AudienceExportJobSummary.setter(Builder::statusDetails)).constructor(StatusDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusDetails").build()}).build();
    private static final SdkField<String> OUTPUT_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("outputLocation").getter(AudienceExportJobSummary.getter(AudienceExportJobSummary::outputLocation)).setter(AudienceExportJobSummary.setter(Builder::outputLocation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputLocation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATE_TIME_FIELD, UPDATE_TIME_FIELD, NAME_FIELD, AUDIENCE_GENERATION_JOB_ARN_FIELD, AUDIENCE_SIZE_FIELD, DESCRIPTION_FIELD, STATUS_FIELD, STATUS_DETAILS_FIELD, OUTPUT_LOCATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AudienceExportJobSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Instant createTime;
    private final Instant updateTime;
    private final String name;
    private final String audienceGenerationJobArn;
    private final AudienceSize audienceSize;
    private final String description;
    private final String status;
    private final StatusDetails statusDetails;
    private final String outputLocation;

    private AudienceExportJobSummary(BuilderImpl builder) {
        this.createTime = builder.createTime;
        this.updateTime = builder.updateTime;
        this.name = builder.name;
        this.audienceGenerationJobArn = builder.audienceGenerationJobArn;
        this.audienceSize = builder.audienceSize;
        this.description = builder.description;
        this.status = builder.status;
        this.statusDetails = builder.statusDetails;
        this.outputLocation = builder.outputLocation;
    }

    public final Instant createTime() {
        return this.createTime;
    }

    public final Instant updateTime() {
        return this.updateTime;
    }

    public final String name() {
        return this.name;
    }

    public final String audienceGenerationJobArn() {
        return this.audienceGenerationJobArn;
    }

    public final AudienceSize audienceSize() {
        return this.audienceSize;
    }

    public final String description() {
        return this.description;
    }

    public final AudienceExportJobStatus status() {
        return AudienceExportJobStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final StatusDetails statusDetails() {
        return this.statusDetails;
    }

    public final String outputLocation() {
        return this.outputLocation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.audienceGenerationJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.audienceSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputLocation());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AudienceExportJobSummary)) {
            return false;
        }
        AudienceExportJobSummary other = (AudienceExportJobSummary)obj;
        return Objects.equals(this.createTime(), other.createTime()) && Objects.equals(this.updateTime(), other.updateTime()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.audienceGenerationJobArn(), other.audienceGenerationJobArn()) && Objects.equals(this.audienceSize(), other.audienceSize()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusDetails(), other.statusDetails()) && Objects.equals(this.outputLocation(), other.outputLocation());
    }

    public final String toString() {
        return ToString.builder((String)"AudienceExportJobSummary").add("CreateTime", (Object)this.createTime()).add("UpdateTime", (Object)this.updateTime()).add("Name", (Object)this.name()).add("AudienceGenerationJobArn", (Object)this.audienceGenerationJobArn()).add("AudienceSize", (Object)this.audienceSize()).add("Description", (Object)this.description()).add("Status", (Object)this.statusAsString()).add("StatusDetails", (Object)this.statusDetails()).add("OutputLocation", (Object)this.outputLocation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "createTime": {
                return Optional.ofNullable(clazz.cast(this.createTime()));
            }
            case "updateTime": {
                return Optional.ofNullable(clazz.cast(this.updateTime()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "audienceGenerationJobArn": {
                return Optional.ofNullable(clazz.cast(this.audienceGenerationJobArn()));
            }
            case "audienceSize": {
                return Optional.ofNullable(clazz.cast(this.audienceSize()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "statusDetails": {
                return Optional.ofNullable(clazz.cast(this.statusDetails()));
            }
            case "outputLocation": {
                return Optional.ofNullable(clazz.cast(this.outputLocation()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("createTime", CREATE_TIME_FIELD);
        map.put("updateTime", UPDATE_TIME_FIELD);
        map.put("name", NAME_FIELD);
        map.put("audienceGenerationJobArn", AUDIENCE_GENERATION_JOB_ARN_FIELD);
        map.put("audienceSize", AUDIENCE_SIZE_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("statusDetails", STATUS_DETAILS_FIELD);
        map.put("outputLocation", OUTPUT_LOCATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AudienceExportJobSummary, T> g) {
        return obj -> g.apply((AudienceExportJobSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant createTime;
        private Instant updateTime;
        private String name;
        private String audienceGenerationJobArn;
        private AudienceSize audienceSize;
        private String description;
        private String status;
        private StatusDetails statusDetails;
        private String outputLocation;

        private BuilderImpl() {
        }

        private BuilderImpl(AudienceExportJobSummary model) {
            this.createTime(model.createTime);
            this.updateTime(model.updateTime);
            this.name(model.name);
            this.audienceGenerationJobArn(model.audienceGenerationJobArn);
            this.audienceSize(model.audienceSize);
            this.description(model.description);
            this.status(model.status);
            this.statusDetails(model.statusDetails);
            this.outputLocation(model.outputLocation);
        }

        public final Instant getCreateTime() {
            return this.createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Instant getUpdateTime() {
            return this.updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getAudienceGenerationJobArn() {
            return this.audienceGenerationJobArn;
        }

        public final void setAudienceGenerationJobArn(String audienceGenerationJobArn) {
            this.audienceGenerationJobArn = audienceGenerationJobArn;
        }

        @Override
        public final Builder audienceGenerationJobArn(String audienceGenerationJobArn) {
            this.audienceGenerationJobArn = audienceGenerationJobArn;
            return this;
        }

        public final AudienceSize.Builder getAudienceSize() {
            return this.audienceSize != null ? this.audienceSize.toBuilder() : null;
        }

        public final void setAudienceSize(AudienceSize.BuilderImpl audienceSize) {
            this.audienceSize = audienceSize != null ? audienceSize.build() : null;
        }

        @Override
        public final Builder audienceSize(AudienceSize audienceSize) {
            this.audienceSize = audienceSize;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AudienceExportJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final StatusDetails.Builder getStatusDetails() {
            return this.statusDetails != null ? this.statusDetails.toBuilder() : null;
        }

        public final void setStatusDetails(StatusDetails.BuilderImpl statusDetails) {
            this.statusDetails = statusDetails != null ? statusDetails.build() : null;
        }

        @Override
        public final Builder statusDetails(StatusDetails statusDetails) {
            this.statusDetails = statusDetails;
            return this;
        }

        public final String getOutputLocation() {
            return this.outputLocation;
        }

        public final void setOutputLocation(String outputLocation) {
            this.outputLocation = outputLocation;
        }

        @Override
        public final Builder outputLocation(String outputLocation) {
            this.outputLocation = outputLocation;
            return this;
        }

        public AudienceExportJobSummary build() {
            return new AudienceExportJobSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AudienceExportJobSummary> {
        public Builder createTime(Instant var1);

        public Builder updateTime(Instant var1);

        public Builder name(String var1);

        public Builder audienceGenerationJobArn(String var1);

        public Builder audienceSize(AudienceSize var1);

        default public Builder audienceSize(Consumer<AudienceSize.Builder> audienceSize) {
            return this.audienceSize((AudienceSize)((AudienceSize.Builder)AudienceSize.builder().applyMutation(audienceSize)).build());
        }

        public Builder description(String var1);

        public Builder status(String var1);

        public Builder status(AudienceExportJobStatus var1);

        public Builder statusDetails(StatusDetails var1);

        default public Builder statusDetails(Consumer<StatusDetails.Builder> statusDetails) {
            return this.statusDetails((StatusDetails)((StatusDetails.Builder)StatusDetails.builder().applyMutation(statusDetails)).build());
        }

        public Builder outputLocation(String var1);
    }
}

