/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanroomsml.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cleanroomsml.model.CleanRoomsMlResponse;
import software.amazon.awssdk.services.cleanroomsml.model.ConfiguredAudienceModelListCopier;
import software.amazon.awssdk.services.cleanroomsml.model.ConfiguredAudienceModelSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListConfiguredAudienceModelsResponse
extends CleanRoomsMlResponse
implements ToCopyableBuilder<Builder, ListConfiguredAudienceModelsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListConfiguredAudienceModelsResponse.getter(ListConfiguredAudienceModelsResponse::nextToken)).setter(ListConfiguredAudienceModelsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<ConfiguredAudienceModelSummary>> CONFIGURED_AUDIENCE_MODELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("configuredAudienceModels").getter(ListConfiguredAudienceModelsResponse.getter(ListConfiguredAudienceModelsResponse::configuredAudienceModels)).setter(ListConfiguredAudienceModelsResponse.setter(Builder::configuredAudienceModels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuredAudienceModels").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ConfiguredAudienceModelSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, CONFIGURED_AUDIENCE_MODELS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListConfiguredAudienceModelsResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<ConfiguredAudienceModelSummary> configuredAudienceModels;

    private ListConfiguredAudienceModelsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.configuredAudienceModels = builder.configuredAudienceModels;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasConfiguredAudienceModels() {
        return this.configuredAudienceModels != null && !(this.configuredAudienceModels instanceof SdkAutoConstructList);
    }

    public final List<ConfiguredAudienceModelSummary> configuredAudienceModels() {
        return this.configuredAudienceModels;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConfiguredAudienceModels() ? this.configuredAudienceModels() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListConfiguredAudienceModelsResponse)) {
            return false;
        }
        ListConfiguredAudienceModelsResponse other = (ListConfiguredAudienceModelsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasConfiguredAudienceModels() == other.hasConfiguredAudienceModels() && Objects.equals(this.configuredAudienceModels(), other.configuredAudienceModels());
    }

    public final String toString() {
        return ToString.builder((String)"ListConfiguredAudienceModelsResponse").add("NextToken", (Object)this.nextToken()).add("ConfiguredAudienceModels", this.hasConfiguredAudienceModels() ? this.configuredAudienceModels() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "configuredAudienceModels": {
                return Optional.ofNullable(clazz.cast(this.configuredAudienceModels()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("configuredAudienceModels", CONFIGURED_AUDIENCE_MODELS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListConfiguredAudienceModelsResponse, T> g) {
        return obj -> g.apply((ListConfiguredAudienceModelsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CleanRoomsMlResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<ConfiguredAudienceModelSummary> configuredAudienceModels = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListConfiguredAudienceModelsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.configuredAudienceModels(model.configuredAudienceModels);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ConfiguredAudienceModelSummary.Builder> getConfiguredAudienceModels() {
            List<ConfiguredAudienceModelSummary.Builder> result = ConfiguredAudienceModelListCopier.copyToBuilder(this.configuredAudienceModels);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConfiguredAudienceModels(Collection<ConfiguredAudienceModelSummary.BuilderImpl> configuredAudienceModels) {
            this.configuredAudienceModels = ConfiguredAudienceModelListCopier.copyFromBuilder(configuredAudienceModels);
        }

        @Override
        public final Builder configuredAudienceModels(Collection<ConfiguredAudienceModelSummary> configuredAudienceModels) {
            this.configuredAudienceModels = ConfiguredAudienceModelListCopier.copy(configuredAudienceModels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configuredAudienceModels(ConfiguredAudienceModelSummary ... configuredAudienceModels) {
            this.configuredAudienceModels(Arrays.asList(configuredAudienceModels));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configuredAudienceModels(Consumer<ConfiguredAudienceModelSummary.Builder> ... configuredAudienceModels) {
            this.configuredAudienceModels(Stream.of(configuredAudienceModels).map(c -> (ConfiguredAudienceModelSummary)((ConfiguredAudienceModelSummary.Builder)ConfiguredAudienceModelSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListConfiguredAudienceModelsResponse build() {
            return new ListConfiguredAudienceModelsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CleanRoomsMlResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListConfiguredAudienceModelsResponse> {
        public Builder nextToken(String var1);

        public Builder configuredAudienceModels(Collection<ConfiguredAudienceModelSummary> var1);

        public Builder configuredAudienceModels(ConfiguredAudienceModelSummary ... var1);

        public Builder configuredAudienceModels(Consumer<ConfiguredAudienceModelSummary.Builder> ... var1);
    }
}

