/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanroomsml.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cleanroomsml.CleanRoomsMlClient;
import software.amazon.awssdk.services.cleanroomsml.internal.UserAgentUtils;
import software.amazon.awssdk.services.cleanroomsml.model.ConfiguredModelAlgorithmAssociationSummary;
import software.amazon.awssdk.services.cleanroomsml.model.ListConfiguredModelAlgorithmAssociationsRequest;
import software.amazon.awssdk.services.cleanroomsml.model.ListConfiguredModelAlgorithmAssociationsResponse;

public class ListConfiguredModelAlgorithmAssociationsIterable
implements SdkIterable<ListConfiguredModelAlgorithmAssociationsResponse> {
    private final CleanRoomsMlClient client;
    private final ListConfiguredModelAlgorithmAssociationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListConfiguredModelAlgorithmAssociationsIterable(CleanRoomsMlClient client, ListConfiguredModelAlgorithmAssociationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListConfiguredModelAlgorithmAssociationsResponseFetcher();
    }

    public Iterator<ListConfiguredModelAlgorithmAssociationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ConfiguredModelAlgorithmAssociationSummary> configuredModelAlgorithmAssociations() {
        Function<ListConfiguredModelAlgorithmAssociationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.configuredModelAlgorithmAssociations() != null) {
                return response.configuredModelAlgorithmAssociations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListConfiguredModelAlgorithmAssociationsResponseFetcher
    implements SyncPageFetcher<ListConfiguredModelAlgorithmAssociationsResponse> {
        private ListConfiguredModelAlgorithmAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(ListConfiguredModelAlgorithmAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListConfiguredModelAlgorithmAssociationsResponse nextPage(ListConfiguredModelAlgorithmAssociationsResponse previousPage) {
            if (previousPage == null) {
                return ListConfiguredModelAlgorithmAssociationsIterable.this.client.listConfiguredModelAlgorithmAssociations(ListConfiguredModelAlgorithmAssociationsIterable.this.firstRequest);
            }
            return ListConfiguredModelAlgorithmAssociationsIterable.this.client.listConfiguredModelAlgorithmAssociations((ListConfiguredModelAlgorithmAssociationsRequest)((Object)ListConfiguredModelAlgorithmAssociationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

