/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanroomsml.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cleanroomsml.model.CleanRoomsMlRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CancelTrainedModelRequest
extends CleanRoomsMlRequest
implements ToCopyableBuilder<Builder, CancelTrainedModelRequest> {
    private static final SdkField<String> MEMBERSHIP_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("membershipIdentifier").getter(CancelTrainedModelRequest.getter(CancelTrainedModelRequest::membershipIdentifier)).setter(CancelTrainedModelRequest.setter(Builder::membershipIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("membershipIdentifier").build()}).build();
    private static final SdkField<String> TRAINED_MODEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("trainedModelArn").getter(CancelTrainedModelRequest.getter(CancelTrainedModelRequest::trainedModelArn)).setter(CancelTrainedModelRequest.setter(Builder::trainedModelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("trainedModelArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMBERSHIP_IDENTIFIER_FIELD, TRAINED_MODEL_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CancelTrainedModelRequest.memberNameToFieldInitializer();
    private final String membershipIdentifier;
    private final String trainedModelArn;

    private CancelTrainedModelRequest(BuilderImpl builder) {
        super(builder);
        this.membershipIdentifier = builder.membershipIdentifier;
        this.trainedModelArn = builder.trainedModelArn;
    }

    public final String membershipIdentifier() {
        return this.membershipIdentifier;
    }

    public final String trainedModelArn() {
        return this.trainedModelArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.membershipIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainedModelArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelTrainedModelRequest)) {
            return false;
        }
        CancelTrainedModelRequest other = (CancelTrainedModelRequest)((Object)obj);
        return Objects.equals(this.membershipIdentifier(), other.membershipIdentifier()) && Objects.equals(this.trainedModelArn(), other.trainedModelArn());
    }

    public final String toString() {
        return ToString.builder((String)"CancelTrainedModelRequest").add("MembershipIdentifier", (Object)this.membershipIdentifier()).add("TrainedModelArn", (Object)this.trainedModelArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "membershipIdentifier": {
                return Optional.ofNullable(clazz.cast(this.membershipIdentifier()));
            }
            case "trainedModelArn": {
                return Optional.ofNullable(clazz.cast(this.trainedModelArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("membershipIdentifier", MEMBERSHIP_IDENTIFIER_FIELD);
        map.put("trainedModelArn", TRAINED_MODEL_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CancelTrainedModelRequest, T> g) {
        return obj -> g.apply((CancelTrainedModelRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CleanRoomsMlRequest.BuilderImpl
    implements Builder {
        private String membershipIdentifier;
        private String trainedModelArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CancelTrainedModelRequest model) {
            super(model);
            this.membershipIdentifier(model.membershipIdentifier);
            this.trainedModelArn(model.trainedModelArn);
        }

        public final String getMembershipIdentifier() {
            return this.membershipIdentifier;
        }

        public final void setMembershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
        }

        @Override
        public final Builder membershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
            return this;
        }

        public final String getTrainedModelArn() {
            return this.trainedModelArn;
        }

        public final void setTrainedModelArn(String trainedModelArn) {
            this.trainedModelArn = trainedModelArn;
        }

        @Override
        public final Builder trainedModelArn(String trainedModelArn) {
            this.trainedModelArn = trainedModelArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CancelTrainedModelRequest build() {
            return new CancelTrainedModelRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CleanRoomsMlRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CancelTrainedModelRequest> {
        public Builder membershipIdentifier(String var1);

        public Builder trainedModelArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

