/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanroomsml.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cleanroomsml.model.CleanRoomsMlResponse;
import software.amazon.awssdk.services.cleanroomsml.model.CollaborationTrainedModelExportJobListCopier;
import software.amazon.awssdk.services.cleanroomsml.model.CollaborationTrainedModelExportJobSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListCollaborationTrainedModelExportJobsResponse
extends CleanRoomsMlResponse
implements ToCopyableBuilder<Builder, ListCollaborationTrainedModelExportJobsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListCollaborationTrainedModelExportJobsResponse.getter(ListCollaborationTrainedModelExportJobsResponse::nextToken)).setter(ListCollaborationTrainedModelExportJobsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<CollaborationTrainedModelExportJobSummary>> COLLABORATION_TRAINED_MODEL_EXPORT_JOBS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("collaborationTrainedModelExportJobs").getter(ListCollaborationTrainedModelExportJobsResponse.getter(ListCollaborationTrainedModelExportJobsResponse::collaborationTrainedModelExportJobs)).setter(ListCollaborationTrainedModelExportJobsResponse.setter(Builder::collaborationTrainedModelExportJobs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collaborationTrainedModelExportJobs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CollaborationTrainedModelExportJobSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, COLLABORATION_TRAINED_MODEL_EXPORT_JOBS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListCollaborationTrainedModelExportJobsResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<CollaborationTrainedModelExportJobSummary> collaborationTrainedModelExportJobs;

    private ListCollaborationTrainedModelExportJobsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.collaborationTrainedModelExportJobs = builder.collaborationTrainedModelExportJobs;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasCollaborationTrainedModelExportJobs() {
        return this.collaborationTrainedModelExportJobs != null && !(this.collaborationTrainedModelExportJobs instanceof SdkAutoConstructList);
    }

    public final List<CollaborationTrainedModelExportJobSummary> collaborationTrainedModelExportJobs() {
        return this.collaborationTrainedModelExportJobs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCollaborationTrainedModelExportJobs() ? this.collaborationTrainedModelExportJobs() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCollaborationTrainedModelExportJobsResponse)) {
            return false;
        }
        ListCollaborationTrainedModelExportJobsResponse other = (ListCollaborationTrainedModelExportJobsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasCollaborationTrainedModelExportJobs() == other.hasCollaborationTrainedModelExportJobs() && Objects.equals(this.collaborationTrainedModelExportJobs(), other.collaborationTrainedModelExportJobs());
    }

    public final String toString() {
        return ToString.builder((String)"ListCollaborationTrainedModelExportJobsResponse").add("NextToken", (Object)this.nextToken()).add("CollaborationTrainedModelExportJobs", this.hasCollaborationTrainedModelExportJobs() ? this.collaborationTrainedModelExportJobs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "collaborationTrainedModelExportJobs": {
                return Optional.ofNullable(clazz.cast(this.collaborationTrainedModelExportJobs()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("collaborationTrainedModelExportJobs", COLLABORATION_TRAINED_MODEL_EXPORT_JOBS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListCollaborationTrainedModelExportJobsResponse, T> g) {
        return obj -> g.apply((ListCollaborationTrainedModelExportJobsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CleanRoomsMlResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<CollaborationTrainedModelExportJobSummary> collaborationTrainedModelExportJobs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListCollaborationTrainedModelExportJobsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.collaborationTrainedModelExportJobs(model.collaborationTrainedModelExportJobs);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<CollaborationTrainedModelExportJobSummary.Builder> getCollaborationTrainedModelExportJobs() {
            List<CollaborationTrainedModelExportJobSummary.Builder> result = CollaborationTrainedModelExportJobListCopier.copyToBuilder(this.collaborationTrainedModelExportJobs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCollaborationTrainedModelExportJobs(Collection<CollaborationTrainedModelExportJobSummary.BuilderImpl> collaborationTrainedModelExportJobs) {
            this.collaborationTrainedModelExportJobs = CollaborationTrainedModelExportJobListCopier.copyFromBuilder(collaborationTrainedModelExportJobs);
        }

        @Override
        public final Builder collaborationTrainedModelExportJobs(Collection<CollaborationTrainedModelExportJobSummary> collaborationTrainedModelExportJobs) {
            this.collaborationTrainedModelExportJobs = CollaborationTrainedModelExportJobListCopier.copy(collaborationTrainedModelExportJobs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder collaborationTrainedModelExportJobs(CollaborationTrainedModelExportJobSummary ... collaborationTrainedModelExportJobs) {
            this.collaborationTrainedModelExportJobs(Arrays.asList(collaborationTrainedModelExportJobs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder collaborationTrainedModelExportJobs(Consumer<CollaborationTrainedModelExportJobSummary.Builder> ... collaborationTrainedModelExportJobs) {
            this.collaborationTrainedModelExportJobs(Stream.of(collaborationTrainedModelExportJobs).map(c -> (CollaborationTrainedModelExportJobSummary)((CollaborationTrainedModelExportJobSummary.Builder)CollaborationTrainedModelExportJobSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListCollaborationTrainedModelExportJobsResponse build() {
            return new ListCollaborationTrainedModelExportJobsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CleanRoomsMlResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListCollaborationTrainedModelExportJobsResponse> {
        public Builder nextToken(String var1);

        public Builder collaborationTrainedModelExportJobs(Collection<CollaborationTrainedModelExportJobSummary> var1);

        public Builder collaborationTrainedModelExportJobs(CollaborationTrainedModelExportJobSummary ... var1);

        public Builder collaborationTrainedModelExportJobs(Consumer<CollaborationTrainedModelExportJobSummary.Builder> ... var1);
    }
}

