/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanroomsml.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cleanroomsml.model.CleanRoomsMlResponse;
import software.amazon.awssdk.services.cleanroomsml.model.TrainingDatasetListCopier;
import software.amazon.awssdk.services.cleanroomsml.model.TrainingDatasetSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTrainingDatasetsResponse
extends CleanRoomsMlResponse
implements ToCopyableBuilder<Builder, ListTrainingDatasetsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListTrainingDatasetsResponse.getter(ListTrainingDatasetsResponse::nextToken)).setter(ListTrainingDatasetsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<TrainingDatasetSummary>> TRAINING_DATASETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("trainingDatasets").getter(ListTrainingDatasetsResponse.getter(ListTrainingDatasetsResponse::trainingDatasets)).setter(ListTrainingDatasetsResponse.setter(Builder::trainingDatasets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trainingDatasets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TrainingDatasetSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, TRAINING_DATASETS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListTrainingDatasetsResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<TrainingDatasetSummary> trainingDatasets;

    private ListTrainingDatasetsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.trainingDatasets = builder.trainingDatasets;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasTrainingDatasets() {
        return this.trainingDatasets != null && !(this.trainingDatasets instanceof SdkAutoConstructList);
    }

    public final List<TrainingDatasetSummary> trainingDatasets() {
        return this.trainingDatasets;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTrainingDatasets() ? this.trainingDatasets() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTrainingDatasetsResponse)) {
            return false;
        }
        ListTrainingDatasetsResponse other = (ListTrainingDatasetsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasTrainingDatasets() == other.hasTrainingDatasets() && Objects.equals(this.trainingDatasets(), other.trainingDatasets());
    }

    public final String toString() {
        return ToString.builder((String)"ListTrainingDatasetsResponse").add("NextToken", (Object)this.nextToken()).add("TrainingDatasets", this.hasTrainingDatasets() ? this.trainingDatasets() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "trainingDatasets": {
                return Optional.ofNullable(clazz.cast(this.trainingDatasets()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("trainingDatasets", TRAINING_DATASETS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListTrainingDatasetsResponse, T> g) {
        return obj -> g.apply((ListTrainingDatasetsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CleanRoomsMlResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<TrainingDatasetSummary> trainingDatasets = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListTrainingDatasetsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.trainingDatasets(model.trainingDatasets);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<TrainingDatasetSummary.Builder> getTrainingDatasets() {
            List<TrainingDatasetSummary.Builder> result = TrainingDatasetListCopier.copyToBuilder(this.trainingDatasets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTrainingDatasets(Collection<TrainingDatasetSummary.BuilderImpl> trainingDatasets) {
            this.trainingDatasets = TrainingDatasetListCopier.copyFromBuilder(trainingDatasets);
        }

        @Override
        public final Builder trainingDatasets(Collection<TrainingDatasetSummary> trainingDatasets) {
            this.trainingDatasets = TrainingDatasetListCopier.copy(trainingDatasets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trainingDatasets(TrainingDatasetSummary ... trainingDatasets) {
            this.trainingDatasets(Arrays.asList(trainingDatasets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trainingDatasets(Consumer<TrainingDatasetSummary.Builder> ... trainingDatasets) {
            this.trainingDatasets(Stream.of(trainingDatasets).map(c -> (TrainingDatasetSummary)((TrainingDatasetSummary.Builder)TrainingDatasetSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListTrainingDatasetsResponse build() {
            return new ListTrainingDatasetsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CleanRoomsMlResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTrainingDatasetsResponse> {
        public Builder nextToken(String var1);

        public Builder trainingDatasets(Collection<TrainingDatasetSummary> var1);

        public Builder trainingDatasets(TrainingDatasetSummary ... var1);

        public Builder trainingDatasets(Consumer<TrainingDatasetSummary.Builder> ... var1);
    }
}

