/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanroomsml.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.cleanroomsml.model.CleanRoomsMlResponse;
import software.amazon.awssdk.services.cleanroomsml.model.InferenceContainerExecutionParameters;
import software.amazon.awssdk.services.cleanroomsml.model.InferenceEnvironmentMapCopier;
import software.amazon.awssdk.services.cleanroomsml.model.InferenceOutputConfiguration;
import software.amazon.awssdk.services.cleanroomsml.model.InferenceResourceConfig;
import software.amazon.awssdk.services.cleanroomsml.model.LogsStatus;
import software.amazon.awssdk.services.cleanroomsml.model.MetricsStatus;
import software.amazon.awssdk.services.cleanroomsml.model.ModelInferenceDataSource;
import software.amazon.awssdk.services.cleanroomsml.model.StatusDetails;
import software.amazon.awssdk.services.cleanroomsml.model.TagMapCopier;
import software.amazon.awssdk.services.cleanroomsml.model.TrainedModelInferenceJobStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetTrainedModelInferenceJobResponse
extends CleanRoomsMlResponse
implements ToCopyableBuilder<Builder, GetTrainedModelInferenceJobResponse> {
    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createTime").getter(GetTrainedModelInferenceJobResponse.getter(GetTrainedModelInferenceJobResponse::createTime)).setter(GetTrainedModelInferenceJobResponse.setter(Builder::createTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updateTime").getter(GetTrainedModelInferenceJobResponse.getter(GetTrainedModelInferenceJobResponse::updateTime)).setter(GetTrainedModelInferenceJobResponse.setter(Builder::updateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> TRAINED_MODEL_INFERENCE_JOB_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("trainedModelInferenceJobArn").getter(GetTrainedModelInferenceJobResponse.getter(GetTrainedModelInferenceJobResponse::trainedModelInferenceJobArn)).setter(GetTrainedModelInferenceJobResponse.setter(Builder::trainedModelInferenceJobArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trainedModelInferenceJobArn").build()}).build();
    private static final SdkField<String> CONFIGURED_MODEL_ALGORITHM_ASSOCIATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("configuredModelAlgorithmAssociationArn").getter(GetTrainedModelInferenceJobResponse.getter(GetTrainedModelInferenceJobResponse::configuredModelAlgorithmAssociationArn)).setter(GetTrainedModelInferenceJobResponse.setter(Builder::configuredModelAlgorithmAssociationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuredModelAlgorithmAssociationArn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(GetTrainedModelInferenceJobResponse.getter(GetTrainedModelInferenceJobResponse::name)).setter(GetTrainedModelInferenceJobResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetTrainedModelInferenceJobResponse.getter(GetTrainedModelInferenceJobResponse::statusAsString)).setter(GetTrainedModelInferenceJobResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> TRAINED_MODEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("trainedModelArn").getter(GetTrainedModelInferenceJobResponse.getter(GetTrainedModelInferenceJobResponse::trainedModelArn)).setter(GetTrainedModelInferenceJobResponse.setter(Builder::trainedModelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trainedModelArn").build()}).build();
    private static final SdkField<InferenceResourceConfig> RESOURCE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("resourceConfig").getter(GetTrainedModelInferenceJobResponse.getter(GetTrainedModelInferenceJobResponse::resourceConfig)).setter(GetTrainedModelInferenceJobResponse.setter(Builder::resourceConfig)).constructor(InferenceResourceConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceConfig").build()}).build();
    private static final SdkField<InferenceOutputConfiguration> OUTPUT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("outputConfiguration").getter(GetTrainedModelInferenceJobResponse.getter(GetTrainedModelInferenceJobResponse::outputConfiguration)).setter(GetTrainedModelInferenceJobResponse.setter(Builder::outputConfiguration)).constructor(InferenceOutputConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputConfiguration").build()}).build();
    private static final SdkField<String> MEMBERSHIP_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("membershipIdentifier").getter(GetTrainedModelInferenceJobResponse.getter(GetTrainedModelInferenceJobResponse::membershipIdentifier)).setter(GetTrainedModelInferenceJobResponse.setter(Builder::membershipIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("membershipIdentifier").build()}).build();
    private static final SdkField<ModelInferenceDataSource> DATA_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("dataSource").getter(GetTrainedModelInferenceJobResponse.getter(GetTrainedModelInferenceJobResponse::dataSource)).setter(GetTrainedModelInferenceJobResponse.setter(Builder::dataSource)).constructor(ModelInferenceDataSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSource").build()}).build();
    private static final SdkField<InferenceContainerExecutionParameters> CONTAINER_EXECUTION_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("containerExecutionParameters").getter(GetTrainedModelInferenceJobResponse.getter(GetTrainedModelInferenceJobResponse::containerExecutionParameters)).setter(GetTrainedModelInferenceJobResponse.setter(Builder::containerExecutionParameters)).constructor(InferenceContainerExecutionParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerExecutionParameters").build()}).build();
    private static final SdkField<StatusDetails> STATUS_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("statusDetails").getter(GetTrainedModelInferenceJobResponse.getter(GetTrainedModelInferenceJobResponse::statusDetails)).setter(GetTrainedModelInferenceJobResponse.setter(Builder::statusDetails)).constructor(StatusDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusDetails").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(GetTrainedModelInferenceJobResponse.getter(GetTrainedModelInferenceJobResponse::description)).setter(GetTrainedModelInferenceJobResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> INFERENCE_CONTAINER_IMAGE_DIGEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("inferenceContainerImageDigest").getter(GetTrainedModelInferenceJobResponse.getter(GetTrainedModelInferenceJobResponse::inferenceContainerImageDigest)).setter(GetTrainedModelInferenceJobResponse.setter(Builder::inferenceContainerImageDigest)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inferenceContainerImageDigest").build()}).build();
    private static final SdkField<Map<String, String>> ENVIRONMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("environment").getter(GetTrainedModelInferenceJobResponse.getter(GetTrainedModelInferenceJobResponse::environment)).setter(GetTrainedModelInferenceJobResponse.setter(Builder::environment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environment").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("kmsKeyArn").getter(GetTrainedModelInferenceJobResponse.getter(GetTrainedModelInferenceJobResponse::kmsKeyArn)).setter(GetTrainedModelInferenceJobResponse.setter(Builder::kmsKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyArn").build()}).build();
    private static final SdkField<String> METRICS_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("metricsStatus").getter(GetTrainedModelInferenceJobResponse.getter(GetTrainedModelInferenceJobResponse::metricsStatusAsString)).setter(GetTrainedModelInferenceJobResponse.setter(Builder::metricsStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricsStatus").build()}).build();
    private static final SdkField<String> METRICS_STATUS_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("metricsStatusDetails").getter(GetTrainedModelInferenceJobResponse.getter(GetTrainedModelInferenceJobResponse::metricsStatusDetails)).setter(GetTrainedModelInferenceJobResponse.setter(Builder::metricsStatusDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricsStatusDetails").build()}).build();
    private static final SdkField<String> LOGS_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("logsStatus").getter(GetTrainedModelInferenceJobResponse.getter(GetTrainedModelInferenceJobResponse::logsStatusAsString)).setter(GetTrainedModelInferenceJobResponse.setter(Builder::logsStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logsStatus").build()}).build();
    private static final SdkField<String> LOGS_STATUS_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("logsStatusDetails").getter(GetTrainedModelInferenceJobResponse.getter(GetTrainedModelInferenceJobResponse::logsStatusDetails)).setter(GetTrainedModelInferenceJobResponse.setter(Builder::logsStatusDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logsStatusDetails").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(GetTrainedModelInferenceJobResponse.getter(GetTrainedModelInferenceJobResponse::tags)).setter(GetTrainedModelInferenceJobResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATE_TIME_FIELD, UPDATE_TIME_FIELD, TRAINED_MODEL_INFERENCE_JOB_ARN_FIELD, CONFIGURED_MODEL_ALGORITHM_ASSOCIATION_ARN_FIELD, NAME_FIELD, STATUS_FIELD, TRAINED_MODEL_ARN_FIELD, RESOURCE_CONFIG_FIELD, OUTPUT_CONFIGURATION_FIELD, MEMBERSHIP_IDENTIFIER_FIELD, DATA_SOURCE_FIELD, CONTAINER_EXECUTION_PARAMETERS_FIELD, STATUS_DETAILS_FIELD, DESCRIPTION_FIELD, INFERENCE_CONTAINER_IMAGE_DIGEST_FIELD, ENVIRONMENT_FIELD, KMS_KEY_ARN_FIELD, METRICS_STATUS_FIELD, METRICS_STATUS_DETAILS_FIELD, LOGS_STATUS_FIELD, LOGS_STATUS_DETAILS_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("createTime", CREATE_TIME_FIELD);
            this.put("updateTime", UPDATE_TIME_FIELD);
            this.put("trainedModelInferenceJobArn", TRAINED_MODEL_INFERENCE_JOB_ARN_FIELD);
            this.put("configuredModelAlgorithmAssociationArn", CONFIGURED_MODEL_ALGORITHM_ASSOCIATION_ARN_FIELD);
            this.put("name", NAME_FIELD);
            this.put("status", STATUS_FIELD);
            this.put("trainedModelArn", TRAINED_MODEL_ARN_FIELD);
            this.put("resourceConfig", RESOURCE_CONFIG_FIELD);
            this.put("outputConfiguration", OUTPUT_CONFIGURATION_FIELD);
            this.put("membershipIdentifier", MEMBERSHIP_IDENTIFIER_FIELD);
            this.put("dataSource", DATA_SOURCE_FIELD);
            this.put("containerExecutionParameters", CONTAINER_EXECUTION_PARAMETERS_FIELD);
            this.put("statusDetails", STATUS_DETAILS_FIELD);
            this.put("description", DESCRIPTION_FIELD);
            this.put("inferenceContainerImageDigest", INFERENCE_CONTAINER_IMAGE_DIGEST_FIELD);
            this.put("environment", ENVIRONMENT_FIELD);
            this.put("kmsKeyArn", KMS_KEY_ARN_FIELD);
            this.put("metricsStatus", METRICS_STATUS_FIELD);
            this.put("metricsStatusDetails", METRICS_STATUS_DETAILS_FIELD);
            this.put("logsStatus", LOGS_STATUS_FIELD);
            this.put("logsStatusDetails", LOGS_STATUS_DETAILS_FIELD);
            this.put("tags", TAGS_FIELD);
        }
    });
    private final Instant createTime;
    private final Instant updateTime;
    private final String trainedModelInferenceJobArn;
    private final String configuredModelAlgorithmAssociationArn;
    private final String name;
    private final String status;
    private final String trainedModelArn;
    private final InferenceResourceConfig resourceConfig;
    private final InferenceOutputConfiguration outputConfiguration;
    private final String membershipIdentifier;
    private final ModelInferenceDataSource dataSource;
    private final InferenceContainerExecutionParameters containerExecutionParameters;
    private final StatusDetails statusDetails;
    private final String description;
    private final String inferenceContainerImageDigest;
    private final Map<String, String> environment;
    private final String kmsKeyArn;
    private final String metricsStatus;
    private final String metricsStatusDetails;
    private final String logsStatus;
    private final String logsStatusDetails;
    private final Map<String, String> tags;

    private GetTrainedModelInferenceJobResponse(BuilderImpl builder) {
        super(builder);
        this.createTime = builder.createTime;
        this.updateTime = builder.updateTime;
        this.trainedModelInferenceJobArn = builder.trainedModelInferenceJobArn;
        this.configuredModelAlgorithmAssociationArn = builder.configuredModelAlgorithmAssociationArn;
        this.name = builder.name;
        this.status = builder.status;
        this.trainedModelArn = builder.trainedModelArn;
        this.resourceConfig = builder.resourceConfig;
        this.outputConfiguration = builder.outputConfiguration;
        this.membershipIdentifier = builder.membershipIdentifier;
        this.dataSource = builder.dataSource;
        this.containerExecutionParameters = builder.containerExecutionParameters;
        this.statusDetails = builder.statusDetails;
        this.description = builder.description;
        this.inferenceContainerImageDigest = builder.inferenceContainerImageDigest;
        this.environment = builder.environment;
        this.kmsKeyArn = builder.kmsKeyArn;
        this.metricsStatus = builder.metricsStatus;
        this.metricsStatusDetails = builder.metricsStatusDetails;
        this.logsStatus = builder.logsStatus;
        this.logsStatusDetails = builder.logsStatusDetails;
        this.tags = builder.tags;
    }

    public final Instant createTime() {
        return this.createTime;
    }

    public final Instant updateTime() {
        return this.updateTime;
    }

    public final String trainedModelInferenceJobArn() {
        return this.trainedModelInferenceJobArn;
    }

    public final String configuredModelAlgorithmAssociationArn() {
        return this.configuredModelAlgorithmAssociationArn;
    }

    public final String name() {
        return this.name;
    }

    public final TrainedModelInferenceJobStatus status() {
        return TrainedModelInferenceJobStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String trainedModelArn() {
        return this.trainedModelArn;
    }

    public final InferenceResourceConfig resourceConfig() {
        return this.resourceConfig;
    }

    public final InferenceOutputConfiguration outputConfiguration() {
        return this.outputConfiguration;
    }

    public final String membershipIdentifier() {
        return this.membershipIdentifier;
    }

    public final ModelInferenceDataSource dataSource() {
        return this.dataSource;
    }

    public final InferenceContainerExecutionParameters containerExecutionParameters() {
        return this.containerExecutionParameters;
    }

    public final StatusDetails statusDetails() {
        return this.statusDetails;
    }

    public final String description() {
        return this.description;
    }

    public final String inferenceContainerImageDigest() {
        return this.inferenceContainerImageDigest;
    }

    public final boolean hasEnvironment() {
        return this.environment != null && !(this.environment instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> environment() {
        return this.environment;
    }

    public final String kmsKeyArn() {
        return this.kmsKeyArn;
    }

    public final MetricsStatus metricsStatus() {
        return MetricsStatus.fromValue(this.metricsStatus);
    }

    public final String metricsStatusAsString() {
        return this.metricsStatus;
    }

    public final String metricsStatusDetails() {
        return this.metricsStatusDetails;
    }

    public final LogsStatus logsStatus() {
        return LogsStatus.fromValue(this.logsStatus);
    }

    public final String logsStatusAsString() {
        return this.logsStatus;
    }

    public final String logsStatusDetails() {
        return this.logsStatusDetails;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainedModelInferenceJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.configuredModelAlgorithmAssociationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainedModelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.membershipIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.containerExecutionParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.inferenceContainerImageDigest());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEnvironment() ? this.environment() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricsStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricsStatusDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.logsStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.logsStatusDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTrainedModelInferenceJobResponse)) {
            return false;
        }
        GetTrainedModelInferenceJobResponse other = (GetTrainedModelInferenceJobResponse)((Object)obj);
        return Objects.equals(this.createTime(), other.createTime()) && Objects.equals(this.updateTime(), other.updateTime()) && Objects.equals(this.trainedModelInferenceJobArn(), other.trainedModelInferenceJobArn()) && Objects.equals(this.configuredModelAlgorithmAssociationArn(), other.configuredModelAlgorithmAssociationArn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.trainedModelArn(), other.trainedModelArn()) && Objects.equals(this.resourceConfig(), other.resourceConfig()) && Objects.equals(this.outputConfiguration(), other.outputConfiguration()) && Objects.equals(this.membershipIdentifier(), other.membershipIdentifier()) && Objects.equals(this.dataSource(), other.dataSource()) && Objects.equals(this.containerExecutionParameters(), other.containerExecutionParameters()) && Objects.equals(this.statusDetails(), other.statusDetails()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.inferenceContainerImageDigest(), other.inferenceContainerImageDigest()) && this.hasEnvironment() == other.hasEnvironment() && Objects.equals(this.environment(), other.environment()) && Objects.equals(this.kmsKeyArn(), other.kmsKeyArn()) && Objects.equals(this.metricsStatusAsString(), other.metricsStatusAsString()) && Objects.equals(this.metricsStatusDetails(), other.metricsStatusDetails()) && Objects.equals(this.logsStatusAsString(), other.logsStatusAsString()) && Objects.equals(this.logsStatusDetails(), other.logsStatusDetails()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"GetTrainedModelInferenceJobResponse").add("CreateTime", (Object)this.createTime()).add("UpdateTime", (Object)this.updateTime()).add("TrainedModelInferenceJobArn", (Object)this.trainedModelInferenceJobArn()).add("ConfiguredModelAlgorithmAssociationArn", (Object)this.configuredModelAlgorithmAssociationArn()).add("Name", (Object)this.name()).add("Status", (Object)this.statusAsString()).add("TrainedModelArn", (Object)this.trainedModelArn()).add("ResourceConfig", (Object)this.resourceConfig()).add("OutputConfiguration", (Object)this.outputConfiguration()).add("MembershipIdentifier", (Object)this.membershipIdentifier()).add("DataSource", (Object)this.dataSource()).add("ContainerExecutionParameters", (Object)this.containerExecutionParameters()).add("StatusDetails", (Object)this.statusDetails()).add("Description", (Object)this.description()).add("InferenceContainerImageDigest", (Object)this.inferenceContainerImageDigest()).add("Environment", this.hasEnvironment() ? this.environment() : null).add("KmsKeyArn", (Object)this.kmsKeyArn()).add("MetricsStatus", (Object)this.metricsStatusAsString()).add("MetricsStatusDetails", (Object)this.metricsStatusDetails()).add("LogsStatus", (Object)this.logsStatusAsString()).add("LogsStatusDetails", (Object)this.logsStatusDetails()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "createTime": {
                return Optional.ofNullable(clazz.cast(this.createTime()));
            }
            case "updateTime": {
                return Optional.ofNullable(clazz.cast(this.updateTime()));
            }
            case "trainedModelInferenceJobArn": {
                return Optional.ofNullable(clazz.cast(this.trainedModelInferenceJobArn()));
            }
            case "configuredModelAlgorithmAssociationArn": {
                return Optional.ofNullable(clazz.cast(this.configuredModelAlgorithmAssociationArn()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "trainedModelArn": {
                return Optional.ofNullable(clazz.cast(this.trainedModelArn()));
            }
            case "resourceConfig": {
                return Optional.ofNullable(clazz.cast(this.resourceConfig()));
            }
            case "outputConfiguration": {
                return Optional.ofNullable(clazz.cast(this.outputConfiguration()));
            }
            case "membershipIdentifier": {
                return Optional.ofNullable(clazz.cast(this.membershipIdentifier()));
            }
            case "dataSource": {
                return Optional.ofNullable(clazz.cast(this.dataSource()));
            }
            case "containerExecutionParameters": {
                return Optional.ofNullable(clazz.cast(this.containerExecutionParameters()));
            }
            case "statusDetails": {
                return Optional.ofNullable(clazz.cast(this.statusDetails()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "inferenceContainerImageDigest": {
                return Optional.ofNullable(clazz.cast(this.inferenceContainerImageDigest()));
            }
            case "environment": {
                return Optional.ofNullable(clazz.cast(this.environment()));
            }
            case "kmsKeyArn": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyArn()));
            }
            case "metricsStatus": {
                return Optional.ofNullable(clazz.cast(this.metricsStatusAsString()));
            }
            case "metricsStatusDetails": {
                return Optional.ofNullable(clazz.cast(this.metricsStatusDetails()));
            }
            case "logsStatus": {
                return Optional.ofNullable(clazz.cast(this.logsStatusAsString()));
            }
            case "logsStatusDetails": {
                return Optional.ofNullable(clazz.cast(this.logsStatusDetails()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetTrainedModelInferenceJobResponse, T> g) {
        return obj -> g.apply((GetTrainedModelInferenceJobResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CleanRoomsMlResponse.BuilderImpl
    implements Builder {
        private Instant createTime;
        private Instant updateTime;
        private String trainedModelInferenceJobArn;
        private String configuredModelAlgorithmAssociationArn;
        private String name;
        private String status;
        private String trainedModelArn;
        private InferenceResourceConfig resourceConfig;
        private InferenceOutputConfiguration outputConfiguration;
        private String membershipIdentifier;
        private ModelInferenceDataSource dataSource;
        private InferenceContainerExecutionParameters containerExecutionParameters;
        private StatusDetails statusDetails;
        private String description;
        private String inferenceContainerImageDigest;
        private Map<String, String> environment = DefaultSdkAutoConstructMap.getInstance();
        private String kmsKeyArn;
        private String metricsStatus;
        private String metricsStatusDetails;
        private String logsStatus;
        private String logsStatusDetails;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetTrainedModelInferenceJobResponse model) {
            super(model);
            this.createTime(model.createTime);
            this.updateTime(model.updateTime);
            this.trainedModelInferenceJobArn(model.trainedModelInferenceJobArn);
            this.configuredModelAlgorithmAssociationArn(model.configuredModelAlgorithmAssociationArn);
            this.name(model.name);
            this.status(model.status);
            this.trainedModelArn(model.trainedModelArn);
            this.resourceConfig(model.resourceConfig);
            this.outputConfiguration(model.outputConfiguration);
            this.membershipIdentifier(model.membershipIdentifier);
            this.dataSource(model.dataSource);
            this.containerExecutionParameters(model.containerExecutionParameters);
            this.statusDetails(model.statusDetails);
            this.description(model.description);
            this.inferenceContainerImageDigest(model.inferenceContainerImageDigest);
            this.environment(model.environment);
            this.kmsKeyArn(model.kmsKeyArn);
            this.metricsStatus(model.metricsStatus);
            this.metricsStatusDetails(model.metricsStatusDetails);
            this.logsStatus(model.logsStatus);
            this.logsStatusDetails(model.logsStatusDetails);
            this.tags(model.tags);
        }

        public final Instant getCreateTime() {
            return this.createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Instant getUpdateTime() {
            return this.updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public final String getTrainedModelInferenceJobArn() {
            return this.trainedModelInferenceJobArn;
        }

        public final void setTrainedModelInferenceJobArn(String trainedModelInferenceJobArn) {
            this.trainedModelInferenceJobArn = trainedModelInferenceJobArn;
        }

        @Override
        public final Builder trainedModelInferenceJobArn(String trainedModelInferenceJobArn) {
            this.trainedModelInferenceJobArn = trainedModelInferenceJobArn;
            return this;
        }

        public final String getConfiguredModelAlgorithmAssociationArn() {
            return this.configuredModelAlgorithmAssociationArn;
        }

        public final void setConfiguredModelAlgorithmAssociationArn(String configuredModelAlgorithmAssociationArn) {
            this.configuredModelAlgorithmAssociationArn = configuredModelAlgorithmAssociationArn;
        }

        @Override
        public final Builder configuredModelAlgorithmAssociationArn(String configuredModelAlgorithmAssociationArn) {
            this.configuredModelAlgorithmAssociationArn = configuredModelAlgorithmAssociationArn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TrainedModelInferenceJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getTrainedModelArn() {
            return this.trainedModelArn;
        }

        public final void setTrainedModelArn(String trainedModelArn) {
            this.trainedModelArn = trainedModelArn;
        }

        @Override
        public final Builder trainedModelArn(String trainedModelArn) {
            this.trainedModelArn = trainedModelArn;
            return this;
        }

        public final InferenceResourceConfig.Builder getResourceConfig() {
            return this.resourceConfig != null ? this.resourceConfig.toBuilder() : null;
        }

        public final void setResourceConfig(InferenceResourceConfig.BuilderImpl resourceConfig) {
            this.resourceConfig = resourceConfig != null ? resourceConfig.build() : null;
        }

        @Override
        public final Builder resourceConfig(InferenceResourceConfig resourceConfig) {
            this.resourceConfig = resourceConfig;
            return this;
        }

        public final InferenceOutputConfiguration.Builder getOutputConfiguration() {
            return this.outputConfiguration != null ? this.outputConfiguration.toBuilder() : null;
        }

        public final void setOutputConfiguration(InferenceOutputConfiguration.BuilderImpl outputConfiguration) {
            this.outputConfiguration = outputConfiguration != null ? outputConfiguration.build() : null;
        }

        @Override
        public final Builder outputConfiguration(InferenceOutputConfiguration outputConfiguration) {
            this.outputConfiguration = outputConfiguration;
            return this;
        }

        public final String getMembershipIdentifier() {
            return this.membershipIdentifier;
        }

        public final void setMembershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
        }

        @Override
        public final Builder membershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
            return this;
        }

        public final ModelInferenceDataSource.Builder getDataSource() {
            return this.dataSource != null ? this.dataSource.toBuilder() : null;
        }

        public final void setDataSource(ModelInferenceDataSource.BuilderImpl dataSource) {
            this.dataSource = dataSource != null ? dataSource.build() : null;
        }

        @Override
        public final Builder dataSource(ModelInferenceDataSource dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        public final InferenceContainerExecutionParameters.Builder getContainerExecutionParameters() {
            return this.containerExecutionParameters != null ? this.containerExecutionParameters.toBuilder() : null;
        }

        public final void setContainerExecutionParameters(InferenceContainerExecutionParameters.BuilderImpl containerExecutionParameters) {
            this.containerExecutionParameters = containerExecutionParameters != null ? containerExecutionParameters.build() : null;
        }

        @Override
        public final Builder containerExecutionParameters(InferenceContainerExecutionParameters containerExecutionParameters) {
            this.containerExecutionParameters = containerExecutionParameters;
            return this;
        }

        public final StatusDetails.Builder getStatusDetails() {
            return this.statusDetails != null ? this.statusDetails.toBuilder() : null;
        }

        public final void setStatusDetails(StatusDetails.BuilderImpl statusDetails) {
            this.statusDetails = statusDetails != null ? statusDetails.build() : null;
        }

        @Override
        public final Builder statusDetails(StatusDetails statusDetails) {
            this.statusDetails = statusDetails;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getInferenceContainerImageDigest() {
            return this.inferenceContainerImageDigest;
        }

        public final void setInferenceContainerImageDigest(String inferenceContainerImageDigest) {
            this.inferenceContainerImageDigest = inferenceContainerImageDigest;
        }

        @Override
        public final Builder inferenceContainerImageDigest(String inferenceContainerImageDigest) {
            this.inferenceContainerImageDigest = inferenceContainerImageDigest;
            return this;
        }

        public final Map<String, String> getEnvironment() {
            if (this.environment instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.environment;
        }

        public final void setEnvironment(Map<String, String> environment) {
            this.environment = InferenceEnvironmentMapCopier.copy(environment);
        }

        @Override
        public final Builder environment(Map<String, String> environment) {
            this.environment = InferenceEnvironmentMapCopier.copy(environment);
            return this;
        }

        public final String getKmsKeyArn() {
            return this.kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        public final String getMetricsStatus() {
            return this.metricsStatus;
        }

        public final void setMetricsStatus(String metricsStatus) {
            this.metricsStatus = metricsStatus;
        }

        @Override
        public final Builder metricsStatus(String metricsStatus) {
            this.metricsStatus = metricsStatus;
            return this;
        }

        @Override
        public final Builder metricsStatus(MetricsStatus metricsStatus) {
            this.metricsStatus(metricsStatus == null ? null : metricsStatus.toString());
            return this;
        }

        public final String getMetricsStatusDetails() {
            return this.metricsStatusDetails;
        }

        public final void setMetricsStatusDetails(String metricsStatusDetails) {
            this.metricsStatusDetails = metricsStatusDetails;
        }

        @Override
        public final Builder metricsStatusDetails(String metricsStatusDetails) {
            this.metricsStatusDetails = metricsStatusDetails;
            return this;
        }

        public final String getLogsStatus() {
            return this.logsStatus;
        }

        public final void setLogsStatus(String logsStatus) {
            this.logsStatus = logsStatus;
        }

        @Override
        public final Builder logsStatus(String logsStatus) {
            this.logsStatus = logsStatus;
            return this;
        }

        @Override
        public final Builder logsStatus(LogsStatus logsStatus) {
            this.logsStatus(logsStatus == null ? null : logsStatus.toString());
            return this;
        }

        public final String getLogsStatusDetails() {
            return this.logsStatusDetails;
        }

        public final void setLogsStatusDetails(String logsStatusDetails) {
            this.logsStatusDetails = logsStatusDetails;
        }

        @Override
        public final Builder logsStatusDetails(String logsStatusDetails) {
            this.logsStatusDetails = logsStatusDetails;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public GetTrainedModelInferenceJobResponse build() {
            return new GetTrainedModelInferenceJobResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CleanRoomsMlResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetTrainedModelInferenceJobResponse> {
        public Builder createTime(Instant var1);

        public Builder updateTime(Instant var1);

        public Builder trainedModelInferenceJobArn(String var1);

        public Builder configuredModelAlgorithmAssociationArn(String var1);

        public Builder name(String var1);

        public Builder status(String var1);

        public Builder status(TrainedModelInferenceJobStatus var1);

        public Builder trainedModelArn(String var1);

        public Builder resourceConfig(InferenceResourceConfig var1);

        default public Builder resourceConfig(Consumer<InferenceResourceConfig.Builder> resourceConfig) {
            return this.resourceConfig((InferenceResourceConfig)((InferenceResourceConfig.Builder)InferenceResourceConfig.builder().applyMutation(resourceConfig)).build());
        }

        public Builder outputConfiguration(InferenceOutputConfiguration var1);

        default public Builder outputConfiguration(Consumer<InferenceOutputConfiguration.Builder> outputConfiguration) {
            return this.outputConfiguration((InferenceOutputConfiguration)((InferenceOutputConfiguration.Builder)InferenceOutputConfiguration.builder().applyMutation(outputConfiguration)).build());
        }

        public Builder membershipIdentifier(String var1);

        public Builder dataSource(ModelInferenceDataSource var1);

        default public Builder dataSource(Consumer<ModelInferenceDataSource.Builder> dataSource) {
            return this.dataSource((ModelInferenceDataSource)((ModelInferenceDataSource.Builder)ModelInferenceDataSource.builder().applyMutation(dataSource)).build());
        }

        public Builder containerExecutionParameters(InferenceContainerExecutionParameters var1);

        default public Builder containerExecutionParameters(Consumer<InferenceContainerExecutionParameters.Builder> containerExecutionParameters) {
            return this.containerExecutionParameters((InferenceContainerExecutionParameters)((InferenceContainerExecutionParameters.Builder)InferenceContainerExecutionParameters.builder().applyMutation(containerExecutionParameters)).build());
        }

        public Builder statusDetails(StatusDetails var1);

        default public Builder statusDetails(Consumer<StatusDetails.Builder> statusDetails) {
            return this.statusDetails((StatusDetails)((StatusDetails.Builder)StatusDetails.builder().applyMutation(statusDetails)).build());
        }

        public Builder description(String var1);

        public Builder inferenceContainerImageDigest(String var1);

        public Builder environment(Map<String, String> var1);

        public Builder kmsKeyArn(String var1);

        public Builder metricsStatus(String var1);

        public Builder metricsStatus(MetricsStatus var1);

        public Builder metricsStatusDetails(String var1);

        public Builder logsStatus(String var1);

        public Builder logsStatus(LogsStatus var1);

        public Builder logsStatusDetails(String var1);

        public Builder tags(Map<String, String> var1);
    }
}

