/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanroomsml.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cleanroomsml.model.ColumnType;
import software.amazon.awssdk.services.cleanroomsml.model.ColumnTypeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ColumnSchema
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ColumnSchema> {
    private static final SdkField<String> COLUMN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("columnName").getter(ColumnSchema.getter(ColumnSchema::columnName)).setter(ColumnSchema.setter(Builder::columnName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("columnName").build()}).build();
    private static final SdkField<List<String>> COLUMN_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("columnTypes").getter(ColumnSchema.getter(ColumnSchema::columnTypesAsStrings)).setter(ColumnSchema.setter(Builder::columnTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("columnTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLUMN_NAME_FIELD, COLUMN_TYPES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ColumnSchema.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String columnName;
    private final List<String> columnTypes;

    private ColumnSchema(BuilderImpl builder) {
        this.columnName = builder.columnName;
        this.columnTypes = builder.columnTypes;
    }

    public final String columnName() {
        return this.columnName;
    }

    public final List<ColumnType> columnTypes() {
        return ColumnTypeListCopier.copyStringToEnum(this.columnTypes);
    }

    public final boolean hasColumnTypes() {
        return this.columnTypes != null && !(this.columnTypes instanceof SdkAutoConstructList);
    }

    public final List<String> columnTypesAsStrings() {
        return this.columnTypes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.columnName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasColumnTypes() ? this.columnTypesAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ColumnSchema)) {
            return false;
        }
        ColumnSchema other = (ColumnSchema)obj;
        return Objects.equals(this.columnName(), other.columnName()) && this.hasColumnTypes() == other.hasColumnTypes() && Objects.equals(this.columnTypesAsStrings(), other.columnTypesAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"ColumnSchema").add("ColumnName", (Object)this.columnName()).add("ColumnTypes", this.hasColumnTypes() ? this.columnTypesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "columnName": {
                return Optional.ofNullable(clazz.cast(this.columnName()));
            }
            case "columnTypes": {
                return Optional.ofNullable(clazz.cast(this.columnTypesAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("columnName", COLUMN_NAME_FIELD);
        map.put("columnTypes", COLUMN_TYPES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ColumnSchema, T> g) {
        return obj -> g.apply((ColumnSchema)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String columnName;
        private List<String> columnTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ColumnSchema model) {
            this.columnName(model.columnName);
            this.columnTypesWithStrings(model.columnTypes);
        }

        public final String getColumnName() {
            return this.columnName;
        }

        public final void setColumnName(String columnName) {
            this.columnName = columnName;
        }

        @Override
        public final Builder columnName(String columnName) {
            this.columnName = columnName;
            return this;
        }

        public final Collection<String> getColumnTypes() {
            if (this.columnTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.columnTypes;
        }

        public final void setColumnTypes(Collection<String> columnTypes) {
            this.columnTypes = ColumnTypeListCopier.copy(columnTypes);
        }

        @Override
        public final Builder columnTypesWithStrings(Collection<String> columnTypes) {
            this.columnTypes = ColumnTypeListCopier.copy(columnTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columnTypesWithStrings(String ... columnTypes) {
            this.columnTypesWithStrings(Arrays.asList(columnTypes));
            return this;
        }

        @Override
        public final Builder columnTypes(Collection<ColumnType> columnTypes) {
            this.columnTypes = ColumnTypeListCopier.copyEnumToString(columnTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columnTypes(ColumnType ... columnTypes) {
            this.columnTypes(Arrays.asList(columnTypes));
            return this;
        }

        public ColumnSchema build() {
            return new ColumnSchema(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ColumnSchema> {
        public Builder columnName(String var1);

        public Builder columnTypesWithStrings(Collection<String> var1);

        public Builder columnTypesWithStrings(String ... var1);

        public Builder columnTypes(Collection<ColumnType> var1);

        public Builder columnTypes(ColumnType ... var1);
    }
}

