/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanroomsml.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cleanroomsml.CleanRoomsMlAsyncClient;
import software.amazon.awssdk.services.cleanroomsml.internal.UserAgentUtils;
import software.amazon.awssdk.services.cleanroomsml.model.ListTrainedModelInferenceJobsRequest;
import software.amazon.awssdk.services.cleanroomsml.model.ListTrainedModelInferenceJobsResponse;
import software.amazon.awssdk.services.cleanroomsml.model.TrainedModelInferenceJobSummary;

public class ListTrainedModelInferenceJobsPublisher
implements SdkPublisher<ListTrainedModelInferenceJobsResponse> {
    private final CleanRoomsMlAsyncClient client;
    private final ListTrainedModelInferenceJobsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListTrainedModelInferenceJobsPublisher(CleanRoomsMlAsyncClient client, ListTrainedModelInferenceJobsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListTrainedModelInferenceJobsPublisher(CleanRoomsMlAsyncClient client, ListTrainedModelInferenceJobsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListTrainedModelInferenceJobsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListTrainedModelInferenceJobsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<TrainedModelInferenceJobSummary> trainedModelInferenceJobs() {
        Function<ListTrainedModelInferenceJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.trainedModelInferenceJobs() != null) {
                return response.trainedModelInferenceJobs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListTrainedModelInferenceJobsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListTrainedModelInferenceJobsResponseFetcher
    implements AsyncPageFetcher<ListTrainedModelInferenceJobsResponse> {
        private ListTrainedModelInferenceJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListTrainedModelInferenceJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListTrainedModelInferenceJobsResponse> nextPage(ListTrainedModelInferenceJobsResponse previousPage) {
            if (previousPage == null) {
                return ListTrainedModelInferenceJobsPublisher.this.client.listTrainedModelInferenceJobs(ListTrainedModelInferenceJobsPublisher.this.firstRequest);
            }
            return ListTrainedModelInferenceJobsPublisher.this.client.listTrainedModelInferenceJobs((ListTrainedModelInferenceJobsRequest)((Object)ListTrainedModelInferenceJobsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

