/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanroomsml.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.cleanroomsml.model.CleanRoomsMlResponse;
import software.amazon.awssdk.services.cleanroomsml.model.GetMLInputChannelResponseConfiguredModelAlgorithmAssociationsListCopier;
import software.amazon.awssdk.services.cleanroomsml.model.InputChannel;
import software.amazon.awssdk.services.cleanroomsml.model.MLInputChannelStatus;
import software.amazon.awssdk.services.cleanroomsml.model.StatusDetails;
import software.amazon.awssdk.services.cleanroomsml.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetMlInputChannelResponse
extends CleanRoomsMlResponse
implements ToCopyableBuilder<Builder, GetMlInputChannelResponse> {
    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createTime").getter(GetMlInputChannelResponse.getter(GetMlInputChannelResponse::createTime)).setter(GetMlInputChannelResponse.setter(Builder::createTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updateTime").getter(GetMlInputChannelResponse.getter(GetMlInputChannelResponse::updateTime)).setter(GetMlInputChannelResponse.setter(Builder::updateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> MEMBERSHIP_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("membershipIdentifier").getter(GetMlInputChannelResponse.getter(GetMlInputChannelResponse::membershipIdentifier)).setter(GetMlInputChannelResponse.setter(Builder::membershipIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("membershipIdentifier").build()}).build();
    private static final SdkField<String> COLLABORATION_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("collaborationIdentifier").getter(GetMlInputChannelResponse.getter(GetMlInputChannelResponse::collaborationIdentifier)).setter(GetMlInputChannelResponse.setter(Builder::collaborationIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collaborationIdentifier").build()}).build();
    private static final SdkField<InputChannel> INPUT_CHANNEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("inputChannel").getter(GetMlInputChannelResponse.getter(GetMlInputChannelResponse::inputChannel)).setter(GetMlInputChannelResponse.setter(Builder::inputChannel)).constructor(InputChannel::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputChannel").build()}).build();
    private static final SdkField<String> PROTECTED_QUERY_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("protectedQueryIdentifier").getter(GetMlInputChannelResponse.getter(GetMlInputChannelResponse::protectedQueryIdentifier)).setter(GetMlInputChannelResponse.setter(Builder::protectedQueryIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protectedQueryIdentifier").build()}).build();
    private static final SdkField<String> ML_INPUT_CHANNEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("mlInputChannelArn").getter(GetMlInputChannelResponse.getter(GetMlInputChannelResponse::mlInputChannelArn)).setter(GetMlInputChannelResponse.setter(Builder::mlInputChannelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mlInputChannelArn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(GetMlInputChannelResponse.getter(GetMlInputChannelResponse::name)).setter(GetMlInputChannelResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<List<String>> CONFIGURED_MODEL_ALGORITHM_ASSOCIATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("configuredModelAlgorithmAssociations").getter(GetMlInputChannelResponse.getter(GetMlInputChannelResponse::configuredModelAlgorithmAssociations)).setter(GetMlInputChannelResponse.setter(Builder::configuredModelAlgorithmAssociations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuredModelAlgorithmAssociations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetMlInputChannelResponse.getter(GetMlInputChannelResponse::statusAsString)).setter(GetMlInputChannelResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<StatusDetails> STATUS_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("statusDetails").getter(GetMlInputChannelResponse.getter(GetMlInputChannelResponse::statusDetails)).setter(GetMlInputChannelResponse.setter(Builder::statusDetails)).constructor(StatusDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusDetails").build()}).build();
    private static final SdkField<Integer> RETENTION_IN_DAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("retentionInDays").getter(GetMlInputChannelResponse.getter(GetMlInputChannelResponse::retentionInDays)).setter(GetMlInputChannelResponse.setter(Builder::retentionInDays)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retentionInDays").build()}).build();
    private static final SdkField<Long> NUMBER_OF_RECORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("numberOfRecords").getter(GetMlInputChannelResponse.getter(GetMlInputChannelResponse::numberOfRecords)).setter(GetMlInputChannelResponse.setter(Builder::numberOfRecords)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberOfRecords").build()}).build();
    private static final SdkField<Double> NUMBER_OF_FILES_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("numberOfFiles").getter(GetMlInputChannelResponse.getter(GetMlInputChannelResponse::numberOfFiles)).setter(GetMlInputChannelResponse.setter(Builder::numberOfFiles)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberOfFiles").build()}).build();
    private static final SdkField<Double> SIZE_IN_GB_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("sizeInGb").getter(GetMlInputChannelResponse.getter(GetMlInputChannelResponse::sizeInGb)).setter(GetMlInputChannelResponse.setter(Builder::sizeInGb)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sizeInGb").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(GetMlInputChannelResponse.getter(GetMlInputChannelResponse::description)).setter(GetMlInputChannelResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("kmsKeyArn").getter(GetMlInputChannelResponse.getter(GetMlInputChannelResponse::kmsKeyArn)).setter(GetMlInputChannelResponse.setter(Builder::kmsKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyArn").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(GetMlInputChannelResponse.getter(GetMlInputChannelResponse::tags)).setter(GetMlInputChannelResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATE_TIME_FIELD, UPDATE_TIME_FIELD, MEMBERSHIP_IDENTIFIER_FIELD, COLLABORATION_IDENTIFIER_FIELD, INPUT_CHANNEL_FIELD, PROTECTED_QUERY_IDENTIFIER_FIELD, ML_INPUT_CHANNEL_ARN_FIELD, NAME_FIELD, CONFIGURED_MODEL_ALGORITHM_ASSOCIATIONS_FIELD, STATUS_FIELD, STATUS_DETAILS_FIELD, RETENTION_IN_DAYS_FIELD, NUMBER_OF_RECORDS_FIELD, NUMBER_OF_FILES_FIELD, SIZE_IN_GB_FIELD, DESCRIPTION_FIELD, KMS_KEY_ARN_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("createTime", CREATE_TIME_FIELD);
            this.put("updateTime", UPDATE_TIME_FIELD);
            this.put("membershipIdentifier", MEMBERSHIP_IDENTIFIER_FIELD);
            this.put("collaborationIdentifier", COLLABORATION_IDENTIFIER_FIELD);
            this.put("inputChannel", INPUT_CHANNEL_FIELD);
            this.put("protectedQueryIdentifier", PROTECTED_QUERY_IDENTIFIER_FIELD);
            this.put("mlInputChannelArn", ML_INPUT_CHANNEL_ARN_FIELD);
            this.put("name", NAME_FIELD);
            this.put("configuredModelAlgorithmAssociations", CONFIGURED_MODEL_ALGORITHM_ASSOCIATIONS_FIELD);
            this.put("status", STATUS_FIELD);
            this.put("statusDetails", STATUS_DETAILS_FIELD);
            this.put("retentionInDays", RETENTION_IN_DAYS_FIELD);
            this.put("numberOfRecords", NUMBER_OF_RECORDS_FIELD);
            this.put("numberOfFiles", NUMBER_OF_FILES_FIELD);
            this.put("sizeInGb", SIZE_IN_GB_FIELD);
            this.put("description", DESCRIPTION_FIELD);
            this.put("kmsKeyArn", KMS_KEY_ARN_FIELD);
            this.put("tags", TAGS_FIELD);
        }
    });
    private final Instant createTime;
    private final Instant updateTime;
    private final String membershipIdentifier;
    private final String collaborationIdentifier;
    private final InputChannel inputChannel;
    private final String protectedQueryIdentifier;
    private final String mlInputChannelArn;
    private final String name;
    private final List<String> configuredModelAlgorithmAssociations;
    private final String status;
    private final StatusDetails statusDetails;
    private final Integer retentionInDays;
    private final Long numberOfRecords;
    private final Double numberOfFiles;
    private final Double sizeInGb;
    private final String description;
    private final String kmsKeyArn;
    private final Map<String, String> tags;

    private GetMlInputChannelResponse(BuilderImpl builder) {
        super(builder);
        this.createTime = builder.createTime;
        this.updateTime = builder.updateTime;
        this.membershipIdentifier = builder.membershipIdentifier;
        this.collaborationIdentifier = builder.collaborationIdentifier;
        this.inputChannel = builder.inputChannel;
        this.protectedQueryIdentifier = builder.protectedQueryIdentifier;
        this.mlInputChannelArn = builder.mlInputChannelArn;
        this.name = builder.name;
        this.configuredModelAlgorithmAssociations = builder.configuredModelAlgorithmAssociations;
        this.status = builder.status;
        this.statusDetails = builder.statusDetails;
        this.retentionInDays = builder.retentionInDays;
        this.numberOfRecords = builder.numberOfRecords;
        this.numberOfFiles = builder.numberOfFiles;
        this.sizeInGb = builder.sizeInGb;
        this.description = builder.description;
        this.kmsKeyArn = builder.kmsKeyArn;
        this.tags = builder.tags;
    }

    public final Instant createTime() {
        return this.createTime;
    }

    public final Instant updateTime() {
        return this.updateTime;
    }

    public final String membershipIdentifier() {
        return this.membershipIdentifier;
    }

    public final String collaborationIdentifier() {
        return this.collaborationIdentifier;
    }

    public final InputChannel inputChannel() {
        return this.inputChannel;
    }

    public final String protectedQueryIdentifier() {
        return this.protectedQueryIdentifier;
    }

    public final String mlInputChannelArn() {
        return this.mlInputChannelArn;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasConfiguredModelAlgorithmAssociations() {
        return this.configuredModelAlgorithmAssociations != null && !(this.configuredModelAlgorithmAssociations instanceof SdkAutoConstructList);
    }

    public final List<String> configuredModelAlgorithmAssociations() {
        return this.configuredModelAlgorithmAssociations;
    }

    public final MLInputChannelStatus status() {
        return MLInputChannelStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final StatusDetails statusDetails() {
        return this.statusDetails;
    }

    public final Integer retentionInDays() {
        return this.retentionInDays;
    }

    public final Long numberOfRecords() {
        return this.numberOfRecords;
    }

    public final Double numberOfFiles() {
        return this.numberOfFiles;
    }

    public final Double sizeInGb() {
        return this.sizeInGb;
    }

    public final String description() {
        return this.description;
    }

    public final String kmsKeyArn() {
        return this.kmsKeyArn;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.membershipIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.collaborationIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputChannel());
        hashCode = 31 * hashCode + Objects.hashCode(this.protectedQueryIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.mlInputChannelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConfiguredModelAlgorithmAssociations() ? this.configuredModelAlgorithmAssociations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.retentionInDays());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfRecords());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfFiles());
        hashCode = 31 * hashCode + Objects.hashCode(this.sizeInGb());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMlInputChannelResponse)) {
            return false;
        }
        GetMlInputChannelResponse other = (GetMlInputChannelResponse)((Object)obj);
        return Objects.equals(this.createTime(), other.createTime()) && Objects.equals(this.updateTime(), other.updateTime()) && Objects.equals(this.membershipIdentifier(), other.membershipIdentifier()) && Objects.equals(this.collaborationIdentifier(), other.collaborationIdentifier()) && Objects.equals(this.inputChannel(), other.inputChannel()) && Objects.equals(this.protectedQueryIdentifier(), other.protectedQueryIdentifier()) && Objects.equals(this.mlInputChannelArn(), other.mlInputChannelArn()) && Objects.equals(this.name(), other.name()) && this.hasConfiguredModelAlgorithmAssociations() == other.hasConfiguredModelAlgorithmAssociations() && Objects.equals(this.configuredModelAlgorithmAssociations(), other.configuredModelAlgorithmAssociations()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusDetails(), other.statusDetails()) && Objects.equals(this.retentionInDays(), other.retentionInDays()) && Objects.equals(this.numberOfRecords(), other.numberOfRecords()) && Objects.equals(this.numberOfFiles(), other.numberOfFiles()) && Objects.equals(this.sizeInGb(), other.sizeInGb()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.kmsKeyArn(), other.kmsKeyArn()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"GetMlInputChannelResponse").add("CreateTime", (Object)this.createTime()).add("UpdateTime", (Object)this.updateTime()).add("MembershipIdentifier", (Object)this.membershipIdentifier()).add("CollaborationIdentifier", (Object)this.collaborationIdentifier()).add("InputChannel", (Object)this.inputChannel()).add("ProtectedQueryIdentifier", (Object)this.protectedQueryIdentifier()).add("MlInputChannelArn", (Object)this.mlInputChannelArn()).add("Name", (Object)this.name()).add("ConfiguredModelAlgorithmAssociations", this.hasConfiguredModelAlgorithmAssociations() ? this.configuredModelAlgorithmAssociations() : null).add("Status", (Object)this.statusAsString()).add("StatusDetails", (Object)this.statusDetails()).add("RetentionInDays", (Object)this.retentionInDays()).add("NumberOfRecords", (Object)this.numberOfRecords()).add("NumberOfFiles", (Object)this.numberOfFiles()).add("SizeInGb", (Object)this.sizeInGb()).add("Description", (Object)this.description()).add("KmsKeyArn", (Object)this.kmsKeyArn()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "createTime": {
                return Optional.ofNullable(clazz.cast(this.createTime()));
            }
            case "updateTime": {
                return Optional.ofNullable(clazz.cast(this.updateTime()));
            }
            case "membershipIdentifier": {
                return Optional.ofNullable(clazz.cast(this.membershipIdentifier()));
            }
            case "collaborationIdentifier": {
                return Optional.ofNullable(clazz.cast(this.collaborationIdentifier()));
            }
            case "inputChannel": {
                return Optional.ofNullable(clazz.cast(this.inputChannel()));
            }
            case "protectedQueryIdentifier": {
                return Optional.ofNullable(clazz.cast(this.protectedQueryIdentifier()));
            }
            case "mlInputChannelArn": {
                return Optional.ofNullable(clazz.cast(this.mlInputChannelArn()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "configuredModelAlgorithmAssociations": {
                return Optional.ofNullable(clazz.cast(this.configuredModelAlgorithmAssociations()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "statusDetails": {
                return Optional.ofNullable(clazz.cast(this.statusDetails()));
            }
            case "retentionInDays": {
                return Optional.ofNullable(clazz.cast(this.retentionInDays()));
            }
            case "numberOfRecords": {
                return Optional.ofNullable(clazz.cast(this.numberOfRecords()));
            }
            case "numberOfFiles": {
                return Optional.ofNullable(clazz.cast(this.numberOfFiles()));
            }
            case "sizeInGb": {
                return Optional.ofNullable(clazz.cast(this.sizeInGb()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "kmsKeyArn": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyArn()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetMlInputChannelResponse, T> g) {
        return obj -> g.apply((GetMlInputChannelResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CleanRoomsMlResponse.BuilderImpl
    implements Builder {
        private Instant createTime;
        private Instant updateTime;
        private String membershipIdentifier;
        private String collaborationIdentifier;
        private InputChannel inputChannel;
        private String protectedQueryIdentifier;
        private String mlInputChannelArn;
        private String name;
        private List<String> configuredModelAlgorithmAssociations = DefaultSdkAutoConstructList.getInstance();
        private String status;
        private StatusDetails statusDetails;
        private Integer retentionInDays;
        private Long numberOfRecords;
        private Double numberOfFiles;
        private Double sizeInGb;
        private String description;
        private String kmsKeyArn;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetMlInputChannelResponse model) {
            super(model);
            this.createTime(model.createTime);
            this.updateTime(model.updateTime);
            this.membershipIdentifier(model.membershipIdentifier);
            this.collaborationIdentifier(model.collaborationIdentifier);
            this.inputChannel(model.inputChannel);
            this.protectedQueryIdentifier(model.protectedQueryIdentifier);
            this.mlInputChannelArn(model.mlInputChannelArn);
            this.name(model.name);
            this.configuredModelAlgorithmAssociations(model.configuredModelAlgorithmAssociations);
            this.status(model.status);
            this.statusDetails(model.statusDetails);
            this.retentionInDays(model.retentionInDays);
            this.numberOfRecords(model.numberOfRecords);
            this.numberOfFiles(model.numberOfFiles);
            this.sizeInGb(model.sizeInGb);
            this.description(model.description);
            this.kmsKeyArn(model.kmsKeyArn);
            this.tags(model.tags);
        }

        public final Instant getCreateTime() {
            return this.createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Instant getUpdateTime() {
            return this.updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public final String getMembershipIdentifier() {
            return this.membershipIdentifier;
        }

        public final void setMembershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
        }

        @Override
        public final Builder membershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
            return this;
        }

        public final String getCollaborationIdentifier() {
            return this.collaborationIdentifier;
        }

        public final void setCollaborationIdentifier(String collaborationIdentifier) {
            this.collaborationIdentifier = collaborationIdentifier;
        }

        @Override
        public final Builder collaborationIdentifier(String collaborationIdentifier) {
            this.collaborationIdentifier = collaborationIdentifier;
            return this;
        }

        public final InputChannel.Builder getInputChannel() {
            return this.inputChannel != null ? this.inputChannel.toBuilder() : null;
        }

        public final void setInputChannel(InputChannel.BuilderImpl inputChannel) {
            this.inputChannel = inputChannel != null ? inputChannel.build() : null;
        }

        @Override
        public final Builder inputChannel(InputChannel inputChannel) {
            this.inputChannel = inputChannel;
            return this;
        }

        public final String getProtectedQueryIdentifier() {
            return this.protectedQueryIdentifier;
        }

        public final void setProtectedQueryIdentifier(String protectedQueryIdentifier) {
            this.protectedQueryIdentifier = protectedQueryIdentifier;
        }

        @Override
        public final Builder protectedQueryIdentifier(String protectedQueryIdentifier) {
            this.protectedQueryIdentifier = protectedQueryIdentifier;
            return this;
        }

        public final String getMlInputChannelArn() {
            return this.mlInputChannelArn;
        }

        public final void setMlInputChannelArn(String mlInputChannelArn) {
            this.mlInputChannelArn = mlInputChannelArn;
        }

        @Override
        public final Builder mlInputChannelArn(String mlInputChannelArn) {
            this.mlInputChannelArn = mlInputChannelArn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Collection<String> getConfiguredModelAlgorithmAssociations() {
            if (this.configuredModelAlgorithmAssociations instanceof SdkAutoConstructList) {
                return null;
            }
            return this.configuredModelAlgorithmAssociations;
        }

        public final void setConfiguredModelAlgorithmAssociations(Collection<String> configuredModelAlgorithmAssociations) {
            this.configuredModelAlgorithmAssociations = GetMLInputChannelResponseConfiguredModelAlgorithmAssociationsListCopier.copy(configuredModelAlgorithmAssociations);
        }

        @Override
        public final Builder configuredModelAlgorithmAssociations(Collection<String> configuredModelAlgorithmAssociations) {
            this.configuredModelAlgorithmAssociations = GetMLInputChannelResponseConfiguredModelAlgorithmAssociationsListCopier.copy(configuredModelAlgorithmAssociations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configuredModelAlgorithmAssociations(String ... configuredModelAlgorithmAssociations) {
            this.configuredModelAlgorithmAssociations(Arrays.asList(configuredModelAlgorithmAssociations));
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(MLInputChannelStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final StatusDetails.Builder getStatusDetails() {
            return this.statusDetails != null ? this.statusDetails.toBuilder() : null;
        }

        public final void setStatusDetails(StatusDetails.BuilderImpl statusDetails) {
            this.statusDetails = statusDetails != null ? statusDetails.build() : null;
        }

        @Override
        public final Builder statusDetails(StatusDetails statusDetails) {
            this.statusDetails = statusDetails;
            return this;
        }

        public final Integer getRetentionInDays() {
            return this.retentionInDays;
        }

        public final void setRetentionInDays(Integer retentionInDays) {
            this.retentionInDays = retentionInDays;
        }

        @Override
        public final Builder retentionInDays(Integer retentionInDays) {
            this.retentionInDays = retentionInDays;
            return this;
        }

        public final Long getNumberOfRecords() {
            return this.numberOfRecords;
        }

        public final void setNumberOfRecords(Long numberOfRecords) {
            this.numberOfRecords = numberOfRecords;
        }

        @Override
        public final Builder numberOfRecords(Long numberOfRecords) {
            this.numberOfRecords = numberOfRecords;
            return this;
        }

        public final Double getNumberOfFiles() {
            return this.numberOfFiles;
        }

        public final void setNumberOfFiles(Double numberOfFiles) {
            this.numberOfFiles = numberOfFiles;
        }

        @Override
        public final Builder numberOfFiles(Double numberOfFiles) {
            this.numberOfFiles = numberOfFiles;
            return this;
        }

        public final Double getSizeInGb() {
            return this.sizeInGb;
        }

        public final void setSizeInGb(Double sizeInGb) {
            this.sizeInGb = sizeInGb;
        }

        @Override
        public final Builder sizeInGb(Double sizeInGb) {
            this.sizeInGb = sizeInGb;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getKmsKeyArn() {
            return this.kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public GetMlInputChannelResponse build() {
            return new GetMlInputChannelResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CleanRoomsMlResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetMlInputChannelResponse> {
        public Builder createTime(Instant var1);

        public Builder updateTime(Instant var1);

        public Builder membershipIdentifier(String var1);

        public Builder collaborationIdentifier(String var1);

        public Builder inputChannel(InputChannel var1);

        default public Builder inputChannel(Consumer<InputChannel.Builder> inputChannel) {
            return this.inputChannel((InputChannel)((InputChannel.Builder)InputChannel.builder().applyMutation(inputChannel)).build());
        }

        public Builder protectedQueryIdentifier(String var1);

        public Builder mlInputChannelArn(String var1);

        public Builder name(String var1);

        public Builder configuredModelAlgorithmAssociations(Collection<String> var1);

        public Builder configuredModelAlgorithmAssociations(String ... var1);

        public Builder status(String var1);

        public Builder status(MLInputChannelStatus var1);

        public Builder statusDetails(StatusDetails var1);

        default public Builder statusDetails(Consumer<StatusDetails.Builder> statusDetails) {
            return this.statusDetails((StatusDetails)((StatusDetails.Builder)StatusDetails.builder().applyMutation(statusDetails)).build());
        }

        public Builder retentionInDays(Integer var1);

        public Builder numberOfRecords(Long var1);

        public Builder numberOfFiles(Double var1);

        public Builder sizeInGb(Double var1);

        public Builder description(String var1);

        public Builder kmsKeyArn(String var1);

        public Builder tags(Map<String, String> var1);
    }
}

