/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanroomsml.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cleanroomsml.model.AudienceModelListCopier;
import software.amazon.awssdk.services.cleanroomsml.model.AudienceModelSummary;
import software.amazon.awssdk.services.cleanroomsml.model.CleanRoomsMlResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAudienceModelsResponse
extends CleanRoomsMlResponse
implements ToCopyableBuilder<Builder, ListAudienceModelsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListAudienceModelsResponse.getter(ListAudienceModelsResponse::nextToken)).setter(ListAudienceModelsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<AudienceModelSummary>> AUDIENCE_MODELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("audienceModels").getter(ListAudienceModelsResponse.getter(ListAudienceModelsResponse::audienceModels)).setter(ListAudienceModelsResponse.setter(Builder::audienceModels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audienceModels").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AudienceModelSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, AUDIENCE_MODELS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("nextToken", NEXT_TOKEN_FIELD);
            this.put("audienceModels", AUDIENCE_MODELS_FIELD);
        }
    });
    private final String nextToken;
    private final List<AudienceModelSummary> audienceModels;

    private ListAudienceModelsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.audienceModels = builder.audienceModels;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasAudienceModels() {
        return this.audienceModels != null && !(this.audienceModels instanceof SdkAutoConstructList);
    }

    public final List<AudienceModelSummary> audienceModels() {
        return this.audienceModels;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAudienceModels() ? this.audienceModels() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAudienceModelsResponse)) {
            return false;
        }
        ListAudienceModelsResponse other = (ListAudienceModelsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasAudienceModels() == other.hasAudienceModels() && Objects.equals(this.audienceModels(), other.audienceModels());
    }

    public final String toString() {
        return ToString.builder((String)"ListAudienceModelsResponse").add("NextToken", (Object)this.nextToken()).add("AudienceModels", this.hasAudienceModels() ? this.audienceModels() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "audienceModels": {
                return Optional.ofNullable(clazz.cast(this.audienceModels()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListAudienceModelsResponse, T> g) {
        return obj -> g.apply((ListAudienceModelsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CleanRoomsMlResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<AudienceModelSummary> audienceModels = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListAudienceModelsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.audienceModels(model.audienceModels);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<AudienceModelSummary.Builder> getAudienceModels() {
            List<AudienceModelSummary.Builder> result = AudienceModelListCopier.copyToBuilder(this.audienceModels);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAudienceModels(Collection<AudienceModelSummary.BuilderImpl> audienceModels) {
            this.audienceModels = AudienceModelListCopier.copyFromBuilder(audienceModels);
        }

        @Override
        public final Builder audienceModels(Collection<AudienceModelSummary> audienceModels) {
            this.audienceModels = AudienceModelListCopier.copy(audienceModels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder audienceModels(AudienceModelSummary ... audienceModels) {
            this.audienceModels(Arrays.asList(audienceModels));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder audienceModels(Consumer<AudienceModelSummary.Builder> ... audienceModels) {
            this.audienceModels(Stream.of(audienceModels).map(c -> (AudienceModelSummary)((AudienceModelSummary.Builder)AudienceModelSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListAudienceModelsResponse build() {
            return new ListAudienceModelsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CleanRoomsMlResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAudienceModelsResponse> {
        public Builder nextToken(String var1);

        public Builder audienceModels(Collection<AudienceModelSummary> var1);

        public Builder audienceModels(AudienceModelSummary ... var1);

        public Builder audienceModels(Consumer<AudienceModelSummary.Builder> ... var1);
    }
}

