/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanroomsml.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cleanroomsml.CleanRoomsMlClient;
import software.amazon.awssdk.services.cleanroomsml.internal.UserAgentUtils;
import software.amazon.awssdk.services.cleanroomsml.model.CollaborationTrainedModelSummary;
import software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationTrainedModelsRequest;
import software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationTrainedModelsResponse;

public class ListCollaborationTrainedModelsIterable
implements SdkIterable<ListCollaborationTrainedModelsResponse> {
    private final CleanRoomsMlClient client;
    private final ListCollaborationTrainedModelsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListCollaborationTrainedModelsIterable(CleanRoomsMlClient client, ListCollaborationTrainedModelsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListCollaborationTrainedModelsResponseFetcher();
    }

    public Iterator<ListCollaborationTrainedModelsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<CollaborationTrainedModelSummary> collaborationTrainedModels() {
        Function<ListCollaborationTrainedModelsResponse, Iterator> getIterator = response -> {
            if (response != null && response.collaborationTrainedModels() != null) {
                return response.collaborationTrainedModels().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListCollaborationTrainedModelsResponseFetcher
    implements SyncPageFetcher<ListCollaborationTrainedModelsResponse> {
        private ListCollaborationTrainedModelsResponseFetcher() {
        }

        public boolean hasNextPage(ListCollaborationTrainedModelsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListCollaborationTrainedModelsResponse nextPage(ListCollaborationTrainedModelsResponse previousPage) {
            if (previousPage == null) {
                return ListCollaborationTrainedModelsIterable.this.client.listCollaborationTrainedModels(ListCollaborationTrainedModelsIterable.this.firstRequest);
            }
            return ListCollaborationTrainedModelsIterable.this.client.listCollaborationTrainedModels((ListCollaborationTrainedModelsRequest)((Object)ListCollaborationTrainedModelsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

